/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.hc.core5.http.nio.support.classic;

import com.databricks.internal.apache.hc.core5.concurrent.FutureCallback;
import com.databricks.internal.apache.hc.core5.http.ContentType;
import com.databricks.internal.apache.hc.core5.http.EntityDetails;
import com.databricks.internal.apache.hc.core5.http.Header;
import com.databricks.internal.apache.hc.core5.http.HttpException;
import com.databricks.internal.apache.hc.core5.http.nio.AsyncEntityConsumer;
import com.databricks.internal.apache.hc.core5.http.nio.CapacityChannel;
import com.databricks.internal.apache.hc.core5.http.nio.support.classic.ContentInputStream;
import com.databricks.internal.apache.hc.core5.http.nio.support.classic.SharedInputBuffer;
import com.databricks.internal.apache.hc.core5.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractClassicEntityConsumer<T>
implements AsyncEntityConsumer<T> {
    private final Executor executor;
    private final SharedInputBuffer buffer;
    private final AtomicReference<State> state;
    private final AtomicReference<T> resultRef;
    private final AtomicReference<Exception> exceptionRef;

    public AbstractClassicEntityConsumer(int initialBufferSize, Executor executor) {
        this.executor = Args.notNull(executor, "Executor");
        this.buffer = new SharedInputBuffer(initialBufferSize);
        this.state = new AtomicReference<State>(State.IDLE);
        this.resultRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    protected abstract T consumeData(ContentType var1, InputStream var2) throws IOException;

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.buffer.updateCapacity(capacityChannel);
    }

    @Override
    public final void streamStart(EntityDetails entityDetails, FutureCallback<T> resultCallback) throws HttpException, IOException {
        ContentType contentType;
        try {
            contentType = ContentType.parse(entityDetails.getContentType());
        }
        catch (UnsupportedCharsetException ex) {
            throw new UnsupportedEncodingException(ex.getMessage());
        }
        if (this.state.compareAndSet(State.IDLE, State.ACTIVE)) {
            this.executor.execute(() -> {
                try {
                    T result = this.consumeData(contentType, new ContentInputStream(this.buffer));
                    this.resultRef.set(result);
                    resultCallback.completed(result);
                }
                catch (Exception ex) {
                    this.buffer.abort();
                    resultCallback.failed(ex);
                }
                finally {
                    this.state.set(State.COMPLETED);
                }
            });
        }
    }

    @Override
    public final void consume(ByteBuffer src) throws IOException {
        this.buffer.fill(src);
    }

    @Override
    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.buffer.markEndStream();
    }

    @Override
    public final void failed(Exception cause) {
        if (this.exceptionRef.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public final Exception getException() {
        return this.exceptionRef.get();
    }

    @Override
    public final T getContent() {
        return this.resultRef.get();
    }

    @Override
    public void releaseResources() {
    }

    private static enum State {
        IDLE,
        ACTIVE,
        COMPLETED;

    }
}

