/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.operator.bc;

import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.databricks.internal.bouncycastle.crypto.Wrapper;
import com.databricks.internal.bouncycastle.crypto.params.KeyParameter;
import com.databricks.internal.bouncycastle.operator.GenericKey;
import com.databricks.internal.bouncycastle.operator.OperatorException;
import com.databricks.internal.bouncycastle.operator.SymmetricKeyUnwrapper;
import java.security.SecureRandom;

public class BcSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyUnwrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public GenericKey generateUnwrappedKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws OperatorException {
        this.wrapper.init(false, this.wrappingKey);
        try {
            return new GenericKey(algorithmIdentifier, this.wrapper.unwrap(byArray, 0, byArray.length));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to unwrap key: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }
}

