/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.jobs;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.jobs.EnforcePolicyComplianceRequest;
import com.databricks.internal.sdk.service.jobs.EnforcePolicyComplianceResponse;
import com.databricks.internal.sdk.service.jobs.GetPolicyComplianceRequest;
import com.databricks.internal.sdk.service.jobs.GetPolicyComplianceResponse;
import com.databricks.internal.sdk.service.jobs.JobCompliance;
import com.databricks.internal.sdk.service.jobs.ListJobComplianceForPolicyResponse;
import com.databricks.internal.sdk.service.jobs.ListJobComplianceRequest;
import com.databricks.internal.sdk.service.jobs.PolicyComplianceForJobsImpl;
import com.databricks.internal.sdk.service.jobs.PolicyComplianceForJobsService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class PolicyComplianceForJobsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyComplianceForJobsAPI.class);
    private final PolicyComplianceForJobsService impl;

    public PolicyComplianceForJobsAPI(ApiClient apiClient) {
        this.impl = new PolicyComplianceForJobsImpl(apiClient);
    }

    public PolicyComplianceForJobsAPI(PolicyComplianceForJobsService mock) {
        this.impl = mock;
    }

    public EnforcePolicyComplianceResponse enforceCompliance(EnforcePolicyComplianceRequest request) {
        return this.impl.enforceCompliance(request);
    }

    public GetPolicyComplianceResponse getCompliance(long jobId) {
        return this.getCompliance(new GetPolicyComplianceRequest().setJobId(jobId));
    }

    public GetPolicyComplianceResponse getCompliance(GetPolicyComplianceRequest request) {
        return this.impl.getCompliance(request);
    }

    public Iterable<JobCompliance> listCompliance(String policyId) {
        return this.listCompliance(new ListJobComplianceRequest().setPolicyId(policyId));
    }

    public Iterable<JobCompliance> listCompliance(ListJobComplianceRequest request) {
        return new Paginator(request, this.impl::listCompliance, ListJobComplianceForPolicyResponse::getJobs, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public PolicyComplianceForJobsService impl() {
        return this.impl;
    }
}

