/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.nimbusds.jwt.SignedJWT;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.IOException;
import java.text.ParseException;

public class DatabricksAuthUtil {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksAuthUtil.class);

    public static String getTokenEndpoint(DatabricksConfig databricksConfig, IDatabricksConnectionContext connectionContext) {
        String userProvidedTokenEndpoint = connectionContext.getTokenEndpoint();
        if (userProvidedTokenEndpoint != null) {
            return userProvidedTokenEndpoint;
        }
        try {
            return databricksConfig.getOidcEndpoints().getTokenEndpoint();
        }
        catch (IOException e) {
            String errorMessage = "Failed to build default token endpoint URL.";
            LOGGER.error(errorMessage);
            throw new DatabricksException(errorMessage, e);
        }
    }

    public static DatabricksConfig initializeConfigWithToken(String newAccessToken, DatabricksConfig config) {
        String hostUrl = config.getHost();
        HttpClient httpClient = config.getHttpClient();
        DatabricksConfig newConfig = new DatabricksConfig();
        newConfig.setHost(hostUrl).setHttpClient(httpClient).setAuthType("pat").setToken(newAccessToken);
        return newConfig;
    }

    public static Boolean isTokenJWT(String accessToken) {
        try {
            SignedJWT signedJWT = SignedJWT.parse(accessToken);
            return true;
        }
        catch (NullPointerException | ParseException e) {
            return false;
        }
    }
}

