/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.io.github.resilience4j.core.registry;

import com.databricks.internal.io.github.resilience4j.core.registry.EntryAddedEvent;
import com.databricks.internal.io.github.resilience4j.core.registry.EntryRemovedEvent;
import com.databricks.internal.io.github.resilience4j.core.registry.EntryReplacedEvent;
import com.databricks.internal.io.github.resilience4j.core.registry.RegistryEventConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class CompositeRegistryEventConsumer<E>
implements RegistryEventConsumer<E> {
    private final List<RegistryEventConsumer<E>> delegates;

    public CompositeRegistryEventConsumer(List<RegistryEventConsumer<E>> delegates) {
        this.delegates = new ArrayList<RegistryEventConsumer<E>>((Collection)Objects.requireNonNull(delegates));
    }

    @Override
    public void onEntryAddedEvent(EntryAddedEvent<E> entryAddedEvent) {
        this.delegates.forEach(consumer -> consumer.onEntryAddedEvent(entryAddedEvent));
    }

    @Override
    public void onEntryRemovedEvent(EntryRemovedEvent<E> entryRemoveEvent) {
        this.delegates.forEach(consumer -> consumer.onEntryRemovedEvent(entryRemoveEvent));
    }

    @Override
    public void onEntryReplacedEvent(EntryReplacedEvent<E> entryReplacedEvent) {
        this.delegates.forEach(consumer -> consumer.onEntryReplacedEvent(entryReplacedEvent));
    }
}

