/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geom.util;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateArrays;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.MultiLineString;
import com.databricks.internal.jts.geom.MultiPoint;
import com.databricks.internal.jts.geom.MultiPolygon;
import com.databricks.internal.jts.geom.Point;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.prep.PreparedGeometry;
import com.databricks.internal.jts.geom.prep.PreparedGeometryFactory;
import com.databricks.internal.jts.operation.buffer.BufferOp;
import com.databricks.internal.jts.operation.overlayng.OverlayNGRobust;
import java.util.ArrayList;
import java.util.List;

public class GeometryFixer {
    private static final boolean DEFAULT_KEEP_MULTI = true;
    private Geometry geom;
    private GeometryFactory factory;
    private boolean isKeepCollapsed = false;
    private boolean isKeepMulti = true;

    public static Geometry fix(Geometry geom) {
        return GeometryFixer.fix(geom, true);
    }

    public static Geometry fix(Geometry geom, boolean isKeepMulti) {
        GeometryFixer fix = new GeometryFixer(geom);
        fix.setKeepMulti(isKeepMulti);
        return fix.getResult();
    }

    public GeometryFixer(Geometry geom) {
        this.geom = geom;
        this.factory = geom.getFactory();
    }

    public void setKeepCollapsed(boolean isKeepCollapsed) {
        this.isKeepCollapsed = isKeepCollapsed;
    }

    public void setKeepMulti(boolean isKeepMulti) {
        this.isKeepMulti = isKeepMulti;
    }

    public Geometry getResult() {
        if (this.geom.getNumGeometries() == 0) {
            return this.geom.copy();
        }
        if (this.geom instanceof Point) {
            return this.fixPoint((Point)this.geom);
        }
        if (this.geom instanceof LinearRing) {
            return this.fixLinearRing((LinearRing)this.geom);
        }
        if (this.geom instanceof LineString) {
            return this.fixLineString((LineString)this.geom);
        }
        if (this.geom instanceof Polygon) {
            return this.fixPolygon((Polygon)this.geom);
        }
        if (this.geom instanceof MultiPoint) {
            return this.fixMultiPoint((MultiPoint)this.geom);
        }
        if (this.geom instanceof MultiLineString) {
            return this.fixMultiLineString((MultiLineString)this.geom);
        }
        if (this.geom instanceof MultiPolygon) {
            return this.fixMultiPolygon((MultiPolygon)this.geom);
        }
        if (this.geom instanceof GeometryCollection) {
            return this.fixCollection((GeometryCollection)this.geom);
        }
        throw new UnsupportedOperationException(this.geom.getClass().getName());
    }

    private Point fixPoint(Point geom) {
        Point pt = this.fixPointElement(geom);
        if (pt == null) {
            return this.factory.createPoint();
        }
        return pt;
    }

    private Point fixPointElement(Point geom) {
        if (geom.isEmpty() || !GeometryFixer.isValidPoint(geom)) {
            return null;
        }
        return (Point)geom.copy();
    }

    private static boolean isValidPoint(Point pt) {
        Coordinate p = pt.getCoordinate();
        return p.isValid();
    }

    private Geometry fixMultiPoint(MultiPoint geom) {
        ArrayList<Point> pts = new ArrayList<Point>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Point fixPt;
            Point pt = (Point)geom.getGeometryN(i);
            if (pt.isEmpty() || (fixPt = this.fixPointElement(pt)) == null) continue;
            pts.add(fixPt);
        }
        if (!this.isKeepMulti && pts.size() == 1) {
            return (Geometry)pts.get(0);
        }
        return this.factory.createMultiPoint(GeometryFactory.toPointArray(pts));
    }

    private Geometry fixLinearRing(LinearRing geom) {
        Geometry fix = this.fixLinearRingElement(geom);
        if (fix == null) {
            return this.factory.createLinearRing();
        }
        return fix;
    }

    private Geometry fixLinearRingElement(LinearRing geom) {
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate[] pts = geom.getCoordinates();
        Coordinate[] ptsFix = GeometryFixer.fixCoordinates(pts);
        if (this.isKeepCollapsed) {
            if (ptsFix.length == 1) {
                return this.factory.createPoint(ptsFix[0]);
            }
            if (ptsFix.length > 1 && ptsFix.length <= 3) {
                return this.factory.createLineString(ptsFix);
            }
        }
        if (ptsFix.length <= 3) {
            return null;
        }
        LinearRing ring = this.factory.createLinearRing(ptsFix);
        if (!ring.isValid()) {
            return this.factory.createLineString(ptsFix);
        }
        return ring;
    }

    private Geometry fixLineString(LineString geom) {
        Geometry fix = this.fixLineStringElement(geom);
        if (fix == null) {
            return this.factory.createLineString();
        }
        return fix;
    }

    private Geometry fixLineStringElement(LineString geom) {
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate[] pts = geom.getCoordinates();
        Coordinate[] ptsFix = GeometryFixer.fixCoordinates(pts);
        if (this.isKeepCollapsed && ptsFix.length == 1) {
            return this.factory.createPoint(ptsFix[0]);
        }
        if (ptsFix.length <= 1) {
            return null;
        }
        return this.factory.createLineString(ptsFix);
    }

    private static Coordinate[] fixCoordinates(Coordinate[] pts) {
        Coordinate[] ptsClean = CoordinateArrays.removeRepeatedOrInvalidPoints(pts);
        return CoordinateArrays.copyDeep(ptsClean);
    }

    private Geometry fixMultiLineString(MultiLineString geom) {
        ArrayList<Geometry> fixed = new ArrayList<Geometry>();
        boolean isMixed = false;
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry fix;
            LineString line = (LineString)geom.getGeometryN(i);
            if (line.isEmpty() || (fix = this.fixLineStringElement(line)) == null) continue;
            if (!(fix instanceof LineString)) {
                isMixed = true;
            }
            fixed.add(fix);
        }
        if (!(fixed.size() != 1 || this.isKeepMulti && fixed.get(0) instanceof LineString)) {
            return (Geometry)fixed.get(0);
        }
        if (isMixed) {
            return this.factory.createGeometryCollection(GeometryFactory.toGeometryArray(fixed));
        }
        return this.factory.createMultiLineString(GeometryFactory.toLineStringArray(fixed));
    }

    private Geometry fixPolygon(Polygon geom) {
        Geometry fix = this.fixPolygonElement(geom);
        if (fix == null) {
            return this.factory.createPolygon();
        }
        return fix;
    }

    private Geometry fixPolygonElement(Polygon geom) {
        LinearRing shell = geom.getExteriorRing();
        Geometry fixShell = this.fixRing(shell);
        if (fixShell.isEmpty()) {
            if (this.isKeepCollapsed) {
                return this.fixLineString(shell);
            }
            return null;
        }
        if (geom.getNumInteriorRing() == 0) {
            return fixShell;
        }
        List<Geometry> holesFixed = this.fixHoles(geom);
        ArrayList<Geometry> holes = new ArrayList<Geometry>();
        ArrayList<Geometry> shells = new ArrayList<Geometry>();
        this.classifyHoles(fixShell, holesFixed, holes, shells);
        Geometry polyWithHoles = this.difference(fixShell, holes);
        if (shells.size() == 0) {
            return polyWithHoles;
        }
        shells.add(polyWithHoles);
        Geometry result = this.union(shells);
        return result;
    }

    private List<Geometry> fixHoles(Polygon geom) {
        ArrayList<Geometry> holes = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumInteriorRing(); ++i) {
            Geometry holeRep = this.fixRing(geom.getInteriorRingN(i));
            if (holeRep == null) continue;
            holes.add(holeRep);
        }
        return holes;
    }

    private void classifyHoles(Geometry shell, List<Geometry> holesFixed, List<Geometry> holes, List<Geometry> shells) {
        PreparedGeometry shellPrep = PreparedGeometryFactory.prepare(shell);
        for (Geometry hole : holesFixed) {
            if (shellPrep.intersects(hole)) {
                holes.add(hole);
                continue;
            }
            shells.add(hole);
        }
    }

    private Geometry difference(Geometry shell, List<Geometry> holes) {
        if (holes == null || holes.size() == 0) {
            return shell;
        }
        Geometry holesUnion = this.union(holes);
        return OverlayNGRobust.overlay(shell, holesUnion, 3);
    }

    private Geometry union(List<Geometry> polys) {
        if (polys.size() == 0) {
            return this.factory.createPolygon();
        }
        if (polys.size() == 1) {
            return polys.get(0);
        }
        return OverlayNGRobust.union(polys);
    }

    private Geometry fixRing(LinearRing ring) {
        Polygon poly = this.factory.createPolygon(ring);
        return BufferOp.bufferByZero(poly, true);
    }

    private Geometry fixMultiPolygon(MultiPolygon geom) {
        ArrayList<Geometry> polys = new ArrayList<Geometry>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)geom.getGeometryN(i);
            Geometry polyFix = this.fixPolygonElement(poly);
            if (polyFix == null || polyFix.isEmpty()) continue;
            polys.add(polyFix);
        }
        if (polys.size() == 0) {
            return this.factory.createMultiPolygon();
        }
        Geometry result = this.union(polys);
        if (this.isKeepMulti && result instanceof Polygon) {
            result = this.factory.createMultiPolygon(new Polygon[]{(Polygon)result});
        }
        return result;
    }

    private Geometry fixCollection(GeometryCollection geom) {
        Geometry[] geomRep = new Geometry[geom.getNumGeometries()];
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            geomRep[i] = GeometryFixer.fix(geom.getGeometryN(i), this.isKeepCollapsed, this.isKeepMulti);
        }
        return this.factory.createGeometryCollection(geomRep);
    }

    private static Geometry fix(Geometry geom, boolean isKeepCollapsed, boolean isKeepMulti) {
        GeometryFixer fix = new GeometryFixer(geom);
        fix.setKeepCollapsed(isKeepCollapsed);
        fix.setKeepMulti(isKeepMulti);
        return fix.getResult();
    }
}

