/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.precision;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.PrecisionModel;
import com.databricks.internal.jts.geom.util.GeometryTransformer;

class PointwisePrecisionReducerTransformer
extends GeometryTransformer {
    private PrecisionModel targetPM;

    public static Geometry reduce(Geometry geom, PrecisionModel targetPM) {
        PointwisePrecisionReducerTransformer trans = new PointwisePrecisionReducerTransformer(targetPM);
        return trans.transform(geom);
    }

    PointwisePrecisionReducerTransformer(PrecisionModel targetPM) {
        this.targetPM = targetPM;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinates, Geometry parent) {
        if (coordinates.size() == 0) {
            return null;
        }
        Coordinate[] coordsReduce = this.reducePointwise(coordinates);
        return this.factory.getCoordinateSequenceFactory().create(coordsReduce);
    }

    private Coordinate[] reducePointwise(CoordinateSequence coordinates) {
        Coordinate[] coordReduce = new Coordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            Coordinate coord = coordinates.getCoordinate(i).copy();
            this.targetPM.makePrecise(coord);
            coordReduce[i] = coord;
        }
        return coordReduce;
    }
}

