/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.hc.client5.http.entity.mime;

import com.databricks.internal.apache.hc.client5.http.entity.mime.AbstractContentBody;
import com.databricks.internal.apache.hc.client5.http.entity.mime.ContentBody;
import com.databricks.internal.apache.hc.client5.http.entity.mime.Header;
import com.databricks.internal.apache.hc.client5.http.entity.mime.MimeField;
import com.databricks.internal.apache.hc.client5.http.entity.mime.MultipartPart;
import com.databricks.internal.apache.hc.core5.http.ContentType;
import com.databricks.internal.apache.hc.core5.http.NameValuePair;
import com.databricks.internal.apache.hc.core5.util.Args;
import com.databricks.internal.apache.hc.core5.util.Asserts;
import java.util.List;

public class MultipartPartBuilder {
    private ContentBody body;
    private final Header header = new Header();

    public static MultipartPartBuilder create(ContentBody body) {
        return new MultipartPartBuilder(body);
    }

    public static MultipartPartBuilder create() {
        return new MultipartPartBuilder();
    }

    MultipartPartBuilder(ContentBody body) {
        this();
        this.body = body;
    }

    MultipartPartBuilder() {
    }

    public MultipartPartBuilder setBody(ContentBody body) {
        this.body = body;
        return this;
    }

    public MultipartPartBuilder addHeader(String name, String value, List<NameValuePair> parameters) {
        Args.notNull(name, "Header name");
        this.header.addField(new MimeField(name, value, parameters));
        return this;
    }

    public MultipartPartBuilder addHeader(String name, String value) {
        Args.notNull(name, "Header name");
        this.header.addField(new MimeField(name, value));
        return this;
    }

    public MultipartPartBuilder setHeader(String name, String value) {
        Args.notNull(name, "Header name");
        this.header.setField(new MimeField(name, value));
        return this;
    }

    public MultipartPartBuilder removeHeaders(String name) {
        Args.notNull(name, "Header name");
        this.header.removeFields(name);
        return this;
    }

    public MultipartPart build() {
        Asserts.notNull(this.body, "Content body");
        Header headerCopy = new Header();
        List<MimeField> fields = this.header.getFields();
        for (MimeField field : fields) {
            headerCopy.addField(field);
        }
        if (headerCopy.getField("Content-Type") == null) {
            ContentType contentType = this.body instanceof AbstractContentBody ? ((AbstractContentBody)this.body).getContentType() : null;
            if (contentType != null) {
                headerCopy.addField(new MimeField("Content-Type", contentType.toString()));
            } else {
                StringBuilder buffer = new StringBuilder();
                buffer.append(this.body.getMimeType());
                if (this.body.getCharset() != null) {
                    buffer.append("; charset=");
                    buffer.append(this.body.getCharset());
                }
                headerCopy.addField(new MimeField("Content-Type", buffer.toString()));
            }
        }
        return new MultipartPart(this.body, headerCopy);
    }
}

