/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.algorithm;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.PrecisionModel;
import com.databricks.internal.jts.io.WKTWriter;
import com.databricks.internal.jts.util.Assert;

public abstract class LineIntersector {
    public static final int DONT_INTERSECT = 0;
    public static final int DO_INTERSECT = 1;
    public static final int COLLINEAR = 2;
    public static final int NO_INTERSECTION = 0;
    public static final int POINT_INTERSECTION = 1;
    public static final int COLLINEAR_INTERSECTION = 2;
    protected int result;
    protected Coordinate[][] inputLines = new Coordinate[2][2];
    protected Coordinate[] intPt = new Coordinate[2];
    protected int[][] intLineIndex;
    protected boolean isProper;
    protected Coordinate pa;
    protected Coordinate pb;
    protected PrecisionModel precisionModel = null;

    public static double computeEdgeDistance(Coordinate p, Coordinate p0, Coordinate p1) {
        double dx = Math.abs(p1.x - p0.x);
        double dy = Math.abs(p1.y - p0.y);
        double dist = -1.0;
        if (p.equals(p0)) {
            dist = 0.0;
        } else if (p.equals(p1)) {
            dist = dx > dy ? dx : dy;
        } else {
            double pdx = Math.abs(p.x - p0.x);
            double pdy = Math.abs(p.y - p0.y);
            dist = dx > dy ? pdx : pdy;
            if (dist == 0.0 && !p.equals(p0)) {
                dist = Math.max(pdx, pdy);
            }
        }
        Assert.isTrue(dist != 0.0 || p.equals(p0), "Bad distance calculation");
        return dist;
    }

    public static double nonRobustComputeEdgeDistance(Coordinate p, Coordinate p1, Coordinate p2) {
        double dx = p.x - p1.x;
        double dy = p.y - p1.y;
        double dist = Math.hypot(dx, dy);
        Assert.isTrue(dist != 0.0 || p.equals(p1), "Invalid distance calculation");
        return dist;
    }

    public LineIntersector() {
        this.intPt[0] = new Coordinate();
        this.intPt[1] = new Coordinate();
        this.pa = this.intPt[0];
        this.pb = this.intPt[1];
        this.result = 0;
    }

    public void setMakePrecise(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public void setPrecisionModel(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public Coordinate getEndpoint(int segmentIndex, int ptIndex) {
        return this.inputLines[segmentIndex][ptIndex];
    }

    public abstract void computeIntersection(Coordinate var1, Coordinate var2, Coordinate var3);

    protected boolean isCollinear() {
        return this.result == 2;
    }

    public void computeIntersection(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate p4) {
        this.inputLines[0][0] = p1;
        this.inputLines[0][1] = p2;
        this.inputLines[1][0] = p3;
        this.inputLines[1][1] = p4;
        this.result = this.computeIntersect(p1, p2, p3, p4);
    }

    protected abstract int computeIntersect(Coordinate var1, Coordinate var2, Coordinate var3, Coordinate var4);

    public String toString() {
        return WKTWriter.toLineString(this.inputLines[0][0], this.inputLines[0][1]) + " - " + WKTWriter.toLineString(this.inputLines[1][0], this.inputLines[1][1]) + this.getTopologySummary();
    }

    private String getTopologySummary() {
        StringBuilder catBuilder = new StringBuilder();
        if (this.isEndPoint()) {
            catBuilder.append(" endpoint");
        }
        if (this.isProper) {
            catBuilder.append(" proper");
        }
        if (this.isCollinear()) {
            catBuilder.append(" collinear");
        }
        return catBuilder.toString();
    }

    protected boolean isEndPoint() {
        return this.hasIntersection() && !this.isProper;
    }

    public boolean hasIntersection() {
        return this.result != 0;
    }

    public int getIntersectionNum() {
        return this.result;
    }

    public Coordinate getIntersection(int intIndex) {
        return this.intPt[intIndex];
    }

    protected void computeIntLineIndex() {
        if (this.intLineIndex == null) {
            this.intLineIndex = new int[2][2];
            this.computeIntLineIndex(0);
            this.computeIntLineIndex(1);
        }
    }

    public boolean isIntersection(Coordinate pt) {
        for (int i = 0; i < this.result; ++i) {
            if (!this.intPt[i].equals2D(pt)) continue;
            return true;
        }
        return false;
    }

    public boolean isInteriorIntersection() {
        if (this.isInteriorIntersection(0)) {
            return true;
        }
        return this.isInteriorIntersection(1);
    }

    public boolean isInteriorIntersection(int inputLineIndex) {
        for (int i = 0; i < this.result; ++i) {
            if (this.intPt[i].equals2D(this.inputLines[inputLineIndex][0]) || this.intPt[i].equals2D(this.inputLines[inputLineIndex][1])) continue;
            return true;
        }
        return false;
    }

    public boolean isProper() {
        return this.hasIntersection() && this.isProper;
    }

    public Coordinate getIntersectionAlongSegment(int segmentIndex, int intIndex) {
        this.computeIntLineIndex();
        return this.intPt[this.intLineIndex[segmentIndex][intIndex]];
    }

    public int getIndexAlongSegment(int segmentIndex, int intIndex) {
        this.computeIntLineIndex();
        return this.intLineIndex[segmentIndex][intIndex];
    }

    protected void computeIntLineIndex(int segmentIndex) {
        double dist1;
        double dist0 = this.getEdgeDistance(segmentIndex, 0);
        if (dist0 > (dist1 = this.getEdgeDistance(segmentIndex, 1))) {
            this.intLineIndex[segmentIndex][0] = 0;
            this.intLineIndex[segmentIndex][1] = 1;
        } else {
            this.intLineIndex[segmentIndex][0] = 1;
            this.intLineIndex[segmentIndex][1] = 0;
        }
    }

    public double getEdgeDistance(int segmentIndex, int intIndex) {
        double dist = LineIntersector.computeEdgeDistance(this.intPt[intIndex], this.inputLines[segmentIndex][0], this.inputLines[segmentIndex][1]);
        return dist;
    }
}

