/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.coverage;

import com.databricks.internal.jts.algorithm.PolygonNodeTopology;
import com.databricks.internal.jts.algorithm.RobustLineIntersector;
import com.databricks.internal.jts.coverage.CoverageRing;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.noding.SegmentIntersector;
import com.databricks.internal.jts.noding.SegmentString;

class InvalidSegmentDetector
implements SegmentIntersector {
    private double distanceTol;

    public InvalidSegmentDetector() {
    }

    public InvalidSegmentDetector(double distanceTol) {
        this.distanceTol = distanceTol;
    }

    @Override
    public void processIntersections(SegmentString ssAdj, int iAdj, SegmentString ssTarget, int iTarget) {
        CoverageRing target = (CoverageRing)ssTarget;
        CoverageRing adj = (CoverageRing)ssAdj;
        if (target.isKnown(iTarget)) {
            return;
        }
        Coordinate t0 = target.getCoordinate(iTarget);
        Coordinate t1 = target.getCoordinate(iTarget + 1);
        Coordinate adj0 = adj.getCoordinate(iAdj);
        Coordinate adj1 = adj.getCoordinate(iAdj + 1);
        if (t0.equals2D(t1) || adj0.equals2D(adj1)) {
            return;
        }
        if (this.isEqual(t0, t1, adj0, adj1)) {
            return;
        }
        boolean isInvalid = this.isInvalid(t0, t1, adj0, adj1, adj, iAdj);
        if (isInvalid) {
            target.markInvalid(iTarget);
        }
    }

    private boolean isEqual(Coordinate t0, Coordinate t1, Coordinate adj0, Coordinate adj1) {
        if (t0.equals2D(adj0) && t1.equals2D(adj1)) {
            return true;
        }
        return t0.equals2D(adj1) && t1.equals2D(adj0);
    }

    private boolean isInvalid(Coordinate tgt0, Coordinate tgt1, Coordinate adj0, Coordinate adj1, CoverageRing adj, int indexAdj) {
        if (this.isCollinearOrInterior(tgt0, tgt1, adj0, adj1, adj, indexAdj)) {
            return true;
        }
        return this.distanceTol > 0.0 && InvalidSegmentDetector.isNearlyParallel(tgt0, tgt1, adj0, adj1, this.distanceTol);
    }

    private boolean isCollinearOrInterior(Coordinate tgt0, Coordinate tgt1, Coordinate adj0, Coordinate adj1, CoverageRing adj, int indexAdj) {
        RobustLineIntersector li = new RobustLineIntersector();
        li.computeIntersection(tgt0, tgt1, adj0, adj1);
        if (!li.hasIntersection()) {
            return false;
        }
        if (li.getIntersectionNum() == 2) {
            return true;
        }
        if (li.isProper() || li.isInteriorIntersection()) {
            return true;
        }
        Coordinate intVertex = li.getIntersection(0);
        boolean isInterior = this.isInteriorSegment(intVertex, tgt0, tgt1, adj, indexAdj);
        return isInterior;
    }

    private boolean isInteriorSegment(Coordinate intVertex, Coordinate tgt0, Coordinate tgt1, CoverageRing adj, int indexAdj) {
        Coordinate tgtEnd = intVertex.equals2D(tgt0) ? tgt1 : tgt0;
        Coordinate adjPrev = adj.findVertexPrev(indexAdj, intVertex);
        Coordinate adjNext = adj.findVertexNext(indexAdj, intVertex);
        if (tgtEnd.equals2D(adjPrev) || tgtEnd.equals2D(adjNext)) {
            return false;
        }
        if (!adj.isInteriorOnRight()) {
            Coordinate temp = adjPrev;
            adjPrev = adjNext;
            adjNext = temp;
        }
        boolean isInterior = PolygonNodeTopology.isInteriorSegment(intVertex, adjPrev, adjNext, tgtEnd);
        return isInterior;
    }

    private static boolean isNearlyParallel(Coordinate p00, Coordinate p01, Coordinate p10, Coordinate p11, double distanceTol) {
        LineSegment line0 = new LineSegment(p00, p01);
        LineSegment line1 = new LineSegment(p10, p11);
        LineSegment proj0 = line0.project(line1);
        if (proj0 == null) {
            return false;
        }
        LineSegment proj1 = line1.project(line0);
        if (proj1 == null) {
            return false;
        }
        if (proj0.getLength() <= distanceTol || proj1.getLength() <= distanceTol) {
            return false;
        }
        if (proj0.p0.distance(proj1.p1) < proj0.p0.distance(proj1.p0)) {
            proj1.reverse();
        }
        return proj0.p0.distance(proj1.p0) <= distanceTol && proj0.p1.distance(proj1.p1) <= distanceTol;
    }

    @Override
    public boolean isDone() {
        return false;
    }
}

