/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geom;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;
import com.databricks.internal.jts.geom.CoordinateSequenceFactory;
import com.databricks.internal.jts.geom.CoordinateSequences;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.MultiLineString;
import com.databricks.internal.jts.geom.MultiPoint;
import com.databricks.internal.jts.geom.MultiPolygon;
import com.databricks.internal.jts.geom.Point;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.PrecisionModel;
import com.databricks.internal.jts.geom.impl.CoordinateArraySequenceFactory;
import com.databricks.internal.jts.geom.util.GeometryEditor;
import com.databricks.internal.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;

public class GeometryFactory
implements Serializable {
    private static final long serialVersionUID = -6820524753094095635L;
    private PrecisionModel precisionModel;
    private CoordinateSequenceFactory coordinateSequenceFactory;
    private int SRID;

    public static Point createPointFromInternalCoord(Coordinate coord, Geometry exemplar) {
        exemplar.getPrecisionModel().makePrecise(coord);
        return exemplar.getFactory().createPoint(coord);
    }

    public GeometryFactory(PrecisionModel precisionModel, int SRID, CoordinateSequenceFactory coordinateSequenceFactory) {
        this.precisionModel = precisionModel;
        this.coordinateSequenceFactory = coordinateSequenceFactory;
        this.SRID = SRID;
    }

    public GeometryFactory(CoordinateSequenceFactory coordinateSequenceFactory) {
        this(new PrecisionModel(), 0, coordinateSequenceFactory);
    }

    public GeometryFactory(PrecisionModel precisionModel) {
        this(precisionModel, 0, GeometryFactory.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory(PrecisionModel precisionModel, int SRID) {
        this(precisionModel, SRID, GeometryFactory.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory() {
        this(new PrecisionModel(), 0);
    }

    private static CoordinateSequenceFactory getDefaultCoordinateSequenceFactory() {
        return CoordinateArraySequenceFactory.instance();
    }

    public static Point[] toPointArray(Collection points) {
        Point[] pointArray = new Point[points.size()];
        return points.toArray(pointArray);
    }

    public static Geometry[] toGeometryArray(Collection geometries) {
        if (geometries == null) {
            return null;
        }
        Geometry[] geometryArray = new Geometry[geometries.size()];
        return geometries.toArray(geometryArray);
    }

    public static LinearRing[] toLinearRingArray(Collection linearRings) {
        LinearRing[] linearRingArray = new LinearRing[linearRings.size()];
        return linearRings.toArray(linearRingArray);
    }

    public static LineString[] toLineStringArray(Collection lineStrings) {
        LineString[] lineStringArray = new LineString[lineStrings.size()];
        return lineStrings.toArray(lineStringArray);
    }

    public static Polygon[] toPolygonArray(Collection polygons) {
        Polygon[] polygonArray = new Polygon[polygons.size()];
        return polygons.toArray(polygonArray);
    }

    public static MultiPolygon[] toMultiPolygonArray(Collection multiPolygons) {
        MultiPolygon[] multiPolygonArray = new MultiPolygon[multiPolygons.size()];
        return multiPolygons.toArray(multiPolygonArray);
    }

    public static MultiLineString[] toMultiLineStringArray(Collection multiLineStrings) {
        MultiLineString[] multiLineStringArray = new MultiLineString[multiLineStrings.size()];
        return multiLineStrings.toArray(multiLineStringArray);
    }

    public static MultiPoint[] toMultiPointArray(Collection multiPoints) {
        MultiPoint[] multiPointArray = new MultiPoint[multiPoints.size()];
        return multiPoints.toArray(multiPointArray);
    }

    public Geometry toGeometry(Envelope envelope) {
        if (envelope.isNull()) {
            return this.createPoint();
        }
        if (envelope.getMinX() == envelope.getMaxX() && envelope.getMinY() == envelope.getMaxY()) {
            return this.createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        if (envelope.getMinX() == envelope.getMaxX() || envelope.getMinY() == envelope.getMaxY()) {
            return this.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY())});
        }
        return this.createPolygon(this.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public Point createPoint() {
        return this.createPoint(this.getCoordinateSequenceFactory().create(new Coordinate[0]));
    }

    public Point createPoint(Coordinate coordinate) {
        return this.createPoint(coordinate != null ? this.getCoordinateSequenceFactory().create(new Coordinate[]{coordinate}) : null);
    }

    public Point createPoint(CoordinateSequence coordinates) {
        return new Point(coordinates, this);
    }

    public MultiLineString createMultiLineString() {
        return new MultiLineString(null, this);
    }

    public MultiLineString createMultiLineString(LineString[] lineStrings) {
        return new MultiLineString(lineStrings, this);
    }

    public GeometryCollection createGeometryCollection() {
        return new GeometryCollection(null, this);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        return new GeometryCollection(geometries, this);
    }

    public MultiPolygon createMultiPolygon() {
        return new MultiPolygon(null, this);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygons) {
        return new MultiPolygon(polygons, this);
    }

    public LinearRing createLinearRing() {
        return this.createLinearRing(this.getCoordinateSequenceFactory().create(new Coordinate[0]));
    }

    public LinearRing createLinearRing(Coordinate[] coordinates) {
        return this.createLinearRing(coordinates != null ? this.getCoordinateSequenceFactory().create(coordinates) : null);
    }

    public LinearRing createLinearRing(CoordinateSequence coordinates) {
        return new LinearRing(coordinates, this);
    }

    public MultiPoint createMultiPoint() {
        return new MultiPoint(null, this);
    }

    public MultiPoint createMultiPoint(Point[] point) {
        return new MultiPoint(point, this);
    }

    public MultiPoint createMultiPoint(Coordinate[] coordinates) {
        return this.createMultiPoint(coordinates != null ? this.getCoordinateSequenceFactory().create(coordinates) : null);
    }

    public MultiPoint createMultiPointFromCoords(Coordinate[] coordinates) {
        return this.createMultiPoint(coordinates != null ? this.getCoordinateSequenceFactory().create(coordinates) : null);
    }

    public MultiPoint createMultiPoint(CoordinateSequence coordinates) {
        if (coordinates == null) {
            return this.createMultiPoint(new Point[0]);
        }
        Point[] points = new Point[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            CoordinateSequence ptSeq = this.getCoordinateSequenceFactory().create(1, coordinates.getDimension(), coordinates.getMeasures());
            CoordinateSequences.copy(coordinates, i, ptSeq, 0, 1);
            points[i] = this.createPoint(ptSeq);
        }
        return this.createMultiPoint(points);
    }

    public Polygon createPolygon(LinearRing shell, LinearRing[] holes) {
        return new Polygon(shell, holes, this);
    }

    public Polygon createPolygon(CoordinateSequence shell) {
        return this.createPolygon(this.createLinearRing(shell));
    }

    public Polygon createPolygon(Coordinate[] shell) {
        return this.createPolygon(this.createLinearRing(shell));
    }

    public Polygon createPolygon(LinearRing shell) {
        return this.createPolygon(shell, null);
    }

    public Polygon createPolygon() {
        return this.createPolygon(null, null);
    }

    public Geometry buildGeometry(Collection geomList) {
        boolean isCollection;
        Class<?> geomClass = null;
        boolean isHeterogeneous = false;
        boolean hasGeometryCollection = false;
        for (Geometry geom : geomList) {
            Class<?> partClass = geom.getClass();
            if (geomClass == null) {
                geomClass = partClass;
            }
            if (partClass != geomClass) {
                isHeterogeneous = true;
            }
            if (!(geom instanceof GeometryCollection)) continue;
            hasGeometryCollection = true;
        }
        if (geomClass == null) {
            return this.createGeometryCollection();
        }
        if (isHeterogeneous || hasGeometryCollection) {
            return this.createGeometryCollection(GeometryFactory.toGeometryArray(geomList));
        }
        Geometry geom0 = (Geometry)geomList.iterator().next();
        boolean bl = isCollection = geomList.size() > 1;
        if (isCollection) {
            if (geom0 instanceof Polygon) {
                return this.createMultiPolygon(GeometryFactory.toPolygonArray(geomList));
            }
            if (geom0 instanceof LineString) {
                return this.createMultiLineString(GeometryFactory.toLineStringArray(geomList));
            }
            if (geom0 instanceof Point) {
                return this.createMultiPoint(GeometryFactory.toPointArray(geomList));
            }
            Assert.shouldNeverReachHere("Unhandled class: " + geom0.getClass().getName());
        }
        return geom0;
    }

    public LineString createLineString() {
        return this.createLineString(this.getCoordinateSequenceFactory().create(new Coordinate[0]));
    }

    public LineString createLineString(Coordinate[] coordinates) {
        return this.createLineString(coordinates != null ? this.getCoordinateSequenceFactory().create(coordinates) : null);
    }

    public LineString createLineString(CoordinateSequence coordinates) {
        return new LineString(coordinates, this);
    }

    public Geometry createEmpty(int dimension) {
        switch (dimension) {
            case -1: {
                return this.createGeometryCollection();
            }
            case 0: {
                return this.createPoint();
            }
            case 1: {
                return this.createLineString();
            }
            case 2: {
                return this.createPolygon();
            }
        }
        throw new IllegalArgumentException("Invalid dimension: " + dimension);
    }

    public Geometry createGeometry(Geometry g2) {
        GeometryEditor editor = new GeometryEditor(this);
        return editor.edit(g2, new CoordSeqCloneOp(this.coordinateSequenceFactory));
    }

    public int getSRID() {
        return this.SRID;
    }

    public CoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.coordinateSequenceFactory;
    }

    private static class CoordSeqCloneOp
    extends GeometryEditor.CoordinateSequenceOperation {
        CoordinateSequenceFactory coordinateSequenceFactory;

        public CoordSeqCloneOp(CoordinateSequenceFactory coordinateSequenceFactory) {
            this.coordinateSequenceFactory = coordinateSequenceFactory;
        }

        @Override
        public CoordinateSequence edit(CoordinateSequence coordSeq, Geometry geometry) {
            return this.coordinateSequenceFactory.create(coordSeq);
        }
    }
}

