/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.buffer;

import com.databricks.internal.jts.algorithm.Angle;
import com.databricks.internal.jts.algorithm.Orientation;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateList;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.Polygon;
import java.util.ArrayList;

public class VariableBuffer {
    private static final int MIN_CAP_SEG_LEN_FACTOR = 4;
    private LineString line;
    private double[] distance;
    private GeometryFactory geomFactory;
    private int quadrantSegs = 8;
    private static final double SNAP_TRIG_TOL = 1.0E-6;

    public static Geometry buffer(Geometry line, double startDistance, double endDistance) {
        double[] distance = VariableBuffer.interpolate((LineString)line, startDistance, endDistance);
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    public static Geometry buffer(Geometry line, double startDistance, double midDistance, double endDistance) {
        double[] distance = VariableBuffer.interpolate((LineString)line, startDistance, midDistance, endDistance);
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    public static Geometry buffer(Geometry line, double[] distance) {
        VariableBuffer vb = new VariableBuffer(line, distance);
        return vb.getResult();
    }

    private static double[] interpolate(LineString line, double startValue, double endValue) {
        startValue = Math.abs(startValue);
        endValue = Math.abs(endValue);
        double[] values = new double[line.getNumPoints()];
        values[0] = startValue;
        values[values.length - 1] = endValue;
        double totalLen = line.getLength();
        Coordinate[] pts = line.getCoordinates();
        double currLen = 0.0;
        for (int i = 1; i < values.length - 1; ++i) {
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / totalLen;
            double delta = lenFrac * (endValue - startValue);
            values[i] = startValue + delta;
        }
        return values;
    }

    private static double[] interpolate(LineString line, double startValue, double midValue, double endValue) {
        startValue = Math.abs(startValue);
        midValue = Math.abs(midValue);
        endValue = Math.abs(endValue);
        double[] values = new double[line.getNumPoints()];
        values[0] = startValue;
        values[values.length - 1] = endValue;
        Coordinate[] pts = line.getCoordinates();
        double lineLen = line.getLength();
        int midIndex = VariableBuffer.indexAtLength(pts, lineLen / 2.0);
        double delMidStart = midValue - startValue;
        double delEndMid = endValue - midValue;
        double lenSM = VariableBuffer.length(pts, 0, midIndex);
        double currLen = 0.0;
        for (int i = 1; i <= midIndex; ++i) {
            double val;
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / lenSM;
            values[i] = val = startValue + lenFrac * delMidStart;
        }
        double lenME = VariableBuffer.length(pts, midIndex, pts.length - 1);
        currLen = 0.0;
        for (int i = midIndex + 1; i < values.length - 1; ++i) {
            double val;
            double segLen = pts[i].distance(pts[i - 1]);
            double lenFrac = (currLen += segLen) / lenME;
            values[i] = val = midValue + lenFrac * delEndMid;
        }
        return values;
    }

    private static int indexAtLength(Coordinate[] pts, double targetLen) {
        double len = 0.0;
        for (int i = 1; i < pts.length; ++i) {
            if (!((len += pts[i].distance(pts[i - 1])) > targetLen)) continue;
            return i;
        }
        return pts.length - 1;
    }

    private static double length(Coordinate[] pts, int i1, int i2) {
        double len = 0.0;
        for (int i = i1 + 1; i <= i2; ++i) {
            len += pts[i].distance(pts[i - 1]);
        }
        return len;
    }

    public VariableBuffer(Geometry line, double[] distance) {
        this.line = (LineString)line;
        this.distance = distance;
        this.geomFactory = line.getFactory();
        if (distance.length != this.line.getNumPoints()) {
            throw new IllegalArgumentException("Number of distances is not equal to number of vertices");
        }
    }

    public Geometry getResult() {
        ArrayList<Polygon> parts = new ArrayList<Polygon>();
        Coordinate[] pts = this.line.getCoordinates();
        for (int i = 1; i < pts.length; ++i) {
            Polygon poly;
            double dist0 = this.distance[i - 1];
            double dist1 = this.distance[i];
            if (!(dist0 > 0.0) && !(dist1 > 0.0) || (poly = this.segmentBuffer(pts[i - 1], pts[i], dist0, dist1)) == null) continue;
            parts.add(poly);
        }
        GeometryCollection partsGeom = this.geomFactory.createGeometryCollection(GeometryFactory.toGeometryArray(parts));
        Geometry buffer = partsGeom.union();
        if (buffer.isEmpty()) {
            return this.geomFactory.createPolygon();
        }
        return buffer;
    }

    private Polygon segmentBuffer(Coordinate p0, Coordinate p1, double dist0, double dist1) {
        if (dist0 <= 0.0 && dist1 <= 0.0) {
            return null;
        }
        if (dist0 > dist1) {
            return this.segmentBufferOriented(p1, p0, dist1, dist0);
        }
        return this.segmentBufferOriented(p0, p1, dist0, dist1);
    }

    private Polygon segmentBufferOriented(Coordinate p0, Coordinate p1, double dist0, double dist1) {
        LineSegment tangent = VariableBuffer.outerTangent(p0, dist0, p1, dist1);
        if (tangent == null) {
            Coordinate center = p0;
            double dist = dist0;
            if (dist1 > dist0) {
                center = p1;
                dist = dist1;
            }
            return this.circle(center, dist);
        }
        LineSegment tangentReflect = this.reflect(tangent, p0, p1, dist0);
        CoordinateList coords = new CoordinateList();
        this.addCap(p1, dist1, tangent.p1, tangentReflect.p1, coords);
        this.addCap(p0, dist0, tangentReflect.p0, tangent.p0, coords);
        coords.closeRing();
        Coordinate[] pts = coords.toCoordinateArray();
        Polygon polygon = this.geomFactory.createPolygon(pts);
        return polygon;
    }

    private LineSegment reflect(LineSegment seg, Coordinate p0, Coordinate p1, double dist0) {
        LineSegment line = new LineSegment(p0, p1);
        Coordinate r0 = line.reflect(seg.p0);
        Coordinate r1 = line.reflect(seg.p1);
        if (dist0 == 0.0) {
            r0 = p0.copy();
        }
        return new LineSegment(r0, r1);
    }

    private Polygon circle(Coordinate center, double radius) {
        if (radius <= 0.0) {
            return null;
        }
        int nPts = 4 * this.quadrantSegs;
        Coordinate[] pts = new Coordinate[nPts + 1];
        double angInc = 1.5707963267948966 / (double)this.quadrantSegs;
        for (int i = 0; i < nPts; ++i) {
            pts[i] = VariableBuffer.projectPolar(center, radius, (double)i * angInc);
        }
        pts[pts.length - 1] = pts[0].copy();
        return this.geomFactory.createPolygon(pts);
    }

    private void addCap(Coordinate p, double r, Coordinate t1, Coordinate t2, CoordinateList coords) {
        if (r == 0.0) {
            coords.add(p.copy(), false);
            return;
        }
        coords.add(t1, false);
        double angStart = Angle.angle(p, t1);
        double angEnd = Angle.angle(p, t2);
        if (angStart < angEnd) {
            angStart += Math.PI * 2;
        }
        int indexStart = this.capAngleIndex(angStart);
        int indexEnd = this.capAngleIndex(angEnd);
        double capSegLen = r * 2.0 * Math.sin(0.7853981633974483 / (double)this.quadrantSegs);
        double minSegLen = capSegLen / 4.0;
        for (int i = indexStart; i >= indexEnd; --i) {
            double ang = this.capAngle(i);
            Coordinate capPt = VariableBuffer.projectPolar(p, r, ang);
            boolean isCapPointHighQuality = true;
            if (i == indexStart && -1 != Orientation.index(p, t1, capPt)) {
                isCapPointHighQuality = false;
            } else if (i == indexEnd && 1 != Orientation.index(p, t2, capPt)) {
                isCapPointHighQuality = false;
            }
            if (capPt.distance(t1) < minSegLen) {
                isCapPointHighQuality = false;
            } else if (capPt.distance(t2) < minSegLen) {
                isCapPointHighQuality = false;
            }
            if (!isCapPointHighQuality) continue;
            coords.add(capPt, false);
        }
        coords.add(t2, false);
    }

    private double capAngle(int index) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs;
        return (double)index * capSegAng;
    }

    private int capAngleIndex(double ang) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs;
        int index = (int)(ang / capSegAng);
        return index;
    }

    private static LineSegment outerTangent(Coordinate c1, double r1, Coordinate c2, double r2) {
        if (r1 > r2) {
            LineSegment seg = VariableBuffer.outerTangent(c2, r2, c1, r1);
            return new LineSegment(seg.p1, seg.p0);
        }
        double x1 = c1.getX();
        double y1 = c1.getY();
        double x2 = c2.getX();
        double y2 = c2.getY();
        double a3 = -Math.atan2(y2 - y1, x2 - x1);
        double dr = r2 - r1;
        double d = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double a2 = Math.asin(dr / d);
        if (Double.isNaN(a2)) {
            return null;
        }
        double a1 = a3 - a2;
        double aa = 1.5707963267948966 - a1;
        double x3 = x1 + r1 * Math.cos(aa);
        double y3 = y1 + r1 * Math.sin(aa);
        double x4 = x2 + r2 * Math.cos(aa);
        double y4 = y2 + r2 * Math.sin(aa);
        return new LineSegment(x3, y3, x4, y4);
    }

    private static Coordinate projectPolar(Coordinate p, double r, double ang) {
        double x = p.getX() + r * VariableBuffer.snapTrig(Math.cos(ang));
        double y = p.getY() + r * VariableBuffer.snapTrig(Math.sin(ang));
        return new Coordinate(x, y);
    }

    private static double snapTrig(double x) {
        if (x > 0.999999) {
            return 1.0;
        }
        if (x < -0.999999) {
            return -1.0;
        }
        if (Math.abs(x) < 1.0E-6) {
            return 0.0;
        }
        return x;
    }
}

