/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.valid;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.index.SpatialIndex;
import com.databricks.internal.jts.index.strtree.STRtree;
import com.databricks.internal.jts.operation.valid.PolygonTopologyAnalyzer;
import java.util.List;

class IndexedNestedHoleTester {
    private Polygon polygon;
    private SpatialIndex index;
    private Coordinate nestedPt;

    public IndexedNestedHoleTester(Polygon poly) {
        this.polygon = poly;
        this.loadIndex();
    }

    private void loadIndex() {
        this.index = new STRtree();
        for (int i = 0; i < this.polygon.getNumInteriorRing(); ++i) {
            LinearRing hole = this.polygon.getInteriorRingN(i);
            Envelope env = hole.getEnvelopeInternal();
            this.index.insert(env, hole);
        }
    }

    public Coordinate getNestedPoint() {
        return this.nestedPt;
    }

    public boolean isNested() {
        for (int i = 0; i < this.polygon.getNumInteriorRing(); ++i) {
            LinearRing hole = this.polygon.getInteriorRingN(i);
            List results = this.index.query(hole.getEnvelopeInternal());
            for (LinearRing testHole : results) {
                if (hole == testHole || !testHole.getEnvelopeInternal().covers(hole.getEnvelopeInternal()) || !PolygonTopologyAnalyzer.isRingNested(hole, testHole)) continue;
                this.nestedPt = hole.getCoordinateN(0);
                return true;
            }
        }
        return false;
    }
}

