/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.triangulate.polygon;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.util.PolygonExtracter;
import com.databricks.internal.jts.triangulate.polygon.PolygonEarClipper;
import com.databricks.internal.jts.triangulate.polygon.PolygonHoleJoiner;
import com.databricks.internal.jts.triangulate.polygon.TriDelaunayImprover;
import com.databricks.internal.jts.triangulate.tri.Tri;
import com.databricks.internal.jts.triangulate.tri.TriangulationBuilder;
import java.util.ArrayList;
import java.util.List;

public class ConstrainedDelaunayTriangulator {
    private final GeometryFactory geomFact;
    private final Geometry inputGeom;
    private List<Tri> triList;

    public static Geometry triangulate(Geometry geom) {
        ConstrainedDelaunayTriangulator cdt = new ConstrainedDelaunayTriangulator(geom);
        return cdt.getResult();
    }

    public ConstrainedDelaunayTriangulator(Geometry inputGeom) {
        this.geomFact = inputGeom.getFactory();
        this.inputGeom = inputGeom;
    }

    public Geometry getResult() {
        this.compute();
        return Tri.toGeometry(this.triList, this.geomFact);
    }

    public List<Tri> getTriangles() {
        this.compute();
        return this.triList;
    }

    private void compute() {
        if (this.triList != null) {
            return;
        }
        List polys = PolygonExtracter.getPolygons(this.inputGeom);
        this.triList = new ArrayList<Tri>();
        for (Polygon poly : polys) {
            List<Tri> polyTriList = this.triangulatePolygon(poly);
            this.triList.addAll(polyTriList);
        }
    }

    List<Tri> triangulatePolygon(Polygon poly) {
        Coordinate[] polyShell = PolygonHoleJoiner.join(poly);
        List<Tri> triList = PolygonEarClipper.triangulate(polyShell);
        TriangulationBuilder.build(triList);
        TriDelaunayImprover.improve(triList);
        return triList;
    }
}

