/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.compute.ClusterCompliance;
import com.databricks.internal.sdk.service.compute.EnforceClusterComplianceRequest;
import com.databricks.internal.sdk.service.compute.EnforceClusterComplianceResponse;
import com.databricks.internal.sdk.service.compute.GetClusterComplianceRequest;
import com.databricks.internal.sdk.service.compute.GetClusterComplianceResponse;
import com.databricks.internal.sdk.service.compute.ListClusterCompliancesRequest;
import com.databricks.internal.sdk.service.compute.ListClusterCompliancesResponse;
import com.databricks.internal.sdk.service.compute.PolicyComplianceForClustersImpl;
import com.databricks.internal.sdk.service.compute.PolicyComplianceForClustersService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class PolicyComplianceForClustersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyComplianceForClustersAPI.class);
    private final PolicyComplianceForClustersService impl;

    public PolicyComplianceForClustersAPI(ApiClient apiClient) {
        this.impl = new PolicyComplianceForClustersImpl(apiClient);
    }

    public PolicyComplianceForClustersAPI(PolicyComplianceForClustersService mock) {
        this.impl = mock;
    }

    public EnforceClusterComplianceResponse enforceCompliance(EnforceClusterComplianceRequest request) {
        return this.impl.enforceCompliance(request);
    }

    public GetClusterComplianceResponse getCompliance(String clusterId) {
        return this.getCompliance(new GetClusterComplianceRequest().setClusterId(clusterId));
    }

    public GetClusterComplianceResponse getCompliance(GetClusterComplianceRequest request) {
        return this.impl.getCompliance(request);
    }

    public Iterable<ClusterCompliance> listCompliance(String policyId) {
        return this.listCompliance(new ListClusterCompliancesRequest().setPolicyId(policyId));
    }

    public Iterable<ClusterCompliance> listCompliance(ListClusterCompliancesRequest request) {
        return new Paginator(request, this.impl::listCompliance, ListClusterCompliancesResponse::getClusters, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public PolicyComplianceForClustersService impl() {
        return this.impl;
    }
}

