/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.dataquality;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.dataquality.CancelRefreshRequest;
import com.databricks.internal.sdk.service.dataquality.CancelRefreshResponse;
import com.databricks.internal.sdk.service.dataquality.CreateMonitorRequest;
import com.databricks.internal.sdk.service.dataquality.CreateRefreshRequest;
import com.databricks.internal.sdk.service.dataquality.DataQualityService;
import com.databricks.internal.sdk.service.dataquality.DeleteMonitorRequest;
import com.databricks.internal.sdk.service.dataquality.DeleteRefreshRequest;
import com.databricks.internal.sdk.service.dataquality.GetMonitorRequest;
import com.databricks.internal.sdk.service.dataquality.GetRefreshRequest;
import com.databricks.internal.sdk.service.dataquality.ListMonitorRequest;
import com.databricks.internal.sdk.service.dataquality.ListMonitorResponse;
import com.databricks.internal.sdk.service.dataquality.ListRefreshRequest;
import com.databricks.internal.sdk.service.dataquality.ListRefreshResponse;
import com.databricks.internal.sdk.service.dataquality.Monitor;
import com.databricks.internal.sdk.service.dataquality.Refresh;
import com.databricks.internal.sdk.service.dataquality.UpdateMonitorRequest;
import com.databricks.internal.sdk.service.dataquality.UpdateRefreshRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class DataQualityImpl
implements DataQualityService {
    private final ApiClient apiClient;

    public DataQualityImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CancelRefreshResponse cancelRefresh(CancelRefreshRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s/refreshes/%s/cancel", request.getObjectType(), request.getObjectId(), request.getRefreshId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CancelRefreshResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Monitor createMonitor(CreateMonitorRequest request) {
        String path = "/api/data-quality/v1/monitors";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getMonitor()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Monitor.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Refresh createRefresh(CreateRefreshRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s/refreshes", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getRefresh()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Refresh.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteMonitor(DeleteMonitorRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteRefresh(DeleteRefreshRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s/refreshes/%s", request.getObjectType(), request.getObjectId(), request.getRefreshId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Monitor getMonitor(GetMonitorRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Monitor.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Refresh getRefresh(GetRefreshRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s/refreshes/%s", request.getObjectType(), request.getObjectId(), request.getRefreshId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Refresh.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListMonitorResponse listMonitor(ListMonitorRequest request) {
        String path = "/api/data-quality/v1/monitors";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListMonitorResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListRefreshResponse listRefresh(ListRefreshRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s/refreshes", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListRefreshResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Monitor updateMonitor(UpdateMonitorRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s", request.getObjectType(), request.getObjectId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getMonitor()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Monitor.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Refresh updateRefresh(UpdateRefreshRequest request) {
        String path = String.format("/api/data-quality/v1/monitors/%s/%s/refreshes/%s", request.getObjectType(), request.getObjectId(), request.getRefreshId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getRefresh()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Refresh.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

