/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.AccountGroupsImpl;
import com.databricks.internal.sdk.service.iam.AccountGroupsService;
import com.databricks.internal.sdk.service.iam.DeleteAccountGroupRequest;
import com.databricks.internal.sdk.service.iam.GetAccountGroupRequest;
import com.databricks.internal.sdk.service.iam.Group;
import com.databricks.internal.sdk.service.iam.ListAccountGroupsRequest;
import com.databricks.internal.sdk.service.iam.ListGroupsResponse;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class AccountGroupsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountGroupsAPI.class);
    private final AccountGroupsService impl;

    public AccountGroupsAPI(ApiClient apiClient) {
        this.impl = new AccountGroupsImpl(apiClient);
    }

    public AccountGroupsAPI(AccountGroupsService mock) {
        this.impl = mock;
    }

    public Group create(Group request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteAccountGroupRequest().setId(id));
    }

    public void delete(DeleteAccountGroupRequest request) {
        this.impl.delete(request);
    }

    public Group get(String id) {
        return this.get(new GetAccountGroupRequest().setId(id));
    }

    public Group get(GetAccountGroupRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Group> list(ListAccountGroupsRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator<ListAccountGroupsRequest, ListGroupsResponse, Group>(request, this.impl::list, ListGroupsResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        }).withDedupe(Group::getId);
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public void update(Group request) {
        this.impl.update(request);
    }

    public AccountGroupsService impl() {
        return this.impl;
    }
}

