/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.CreateServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.DeleteServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.GetServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.ListServicePrincipalResponse;
import com.databricks.internal.sdk.service.iam.ListServicePrincipalsRequest;
import com.databricks.internal.sdk.service.iam.PatchServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.ServicePrincipal;
import com.databricks.internal.sdk.service.iam.ServicePrincipalsV2Impl;
import com.databricks.internal.sdk.service.iam.ServicePrincipalsV2Service;
import com.databricks.internal.sdk.service.iam.UpdateServicePrincipalRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class ServicePrincipalsV2API {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePrincipalsV2API.class);
    private final ServicePrincipalsV2Service impl;

    public ServicePrincipalsV2API(ApiClient apiClient) {
        this.impl = new ServicePrincipalsV2Impl(apiClient);
    }

    public ServicePrincipalsV2API(ServicePrincipalsV2Service mock) {
        this.impl = mock;
    }

    public ServicePrincipal create(CreateServicePrincipalRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteServicePrincipalRequest().setId(id));
    }

    public void delete(DeleteServicePrincipalRequest request) {
        this.impl.delete(request);
    }

    public ServicePrincipal get(String id) {
        return this.get(new GetServicePrincipalRequest().setId(id));
    }

    public ServicePrincipal get(GetServicePrincipalRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ServicePrincipal> list(ListServicePrincipalsRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator(request, this.impl::list, ListServicePrincipalResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        });
    }

    public void patch(PatchServicePrincipalRequest request) {
        this.impl.patch(request);
    }

    public void update(UpdateServicePrincipalRequest request) {
        this.impl.update(request);
    }

    public ServicePrincipalsV2Service impl() {
        return this.impl;
    }
}

