/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.BatchGetProvidersRequest;
import com.databricks.internal.sdk.service.marketplace.BatchGetProvidersResponse;
import com.databricks.internal.sdk.service.marketplace.ConsumerProvidersImpl;
import com.databricks.internal.sdk.service.marketplace.ConsumerProvidersService;
import com.databricks.internal.sdk.service.marketplace.GetProviderRequest;
import com.databricks.internal.sdk.service.marketplace.GetProviderResponse;
import com.databricks.internal.sdk.service.marketplace.ListConsumerProvidersRequest;
import com.databricks.internal.sdk.service.marketplace.ListProvidersResponse;
import com.databricks.internal.sdk.service.marketplace.ProviderInfo;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class ConsumerProvidersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerProvidersAPI.class);
    private final ConsumerProvidersService impl;

    public ConsumerProvidersAPI(ApiClient apiClient) {
        this.impl = new ConsumerProvidersImpl(apiClient);
    }

    public ConsumerProvidersAPI(ConsumerProvidersService mock) {
        this.impl = mock;
    }

    public BatchGetProvidersResponse batchGet(BatchGetProvidersRequest request) {
        return this.impl.batchGet(request);
    }

    public GetProviderResponse get(String id) {
        return this.get(new GetProviderRequest().setId(id));
    }

    public GetProviderResponse get(GetProviderRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ProviderInfo> list(ListConsumerProvidersRequest request) {
        return new Paginator(request, this.impl::list, ListProvidersResponse::getProviders, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ConsumerProvidersService impl() {
        return this.impl;
    }
}

