/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sql;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.sql.Alert;
import com.databricks.internal.sdk.service.sql.AlertsImpl;
import com.databricks.internal.sdk.service.sql.AlertsService;
import com.databricks.internal.sdk.service.sql.CreateAlertRequest;
import com.databricks.internal.sdk.service.sql.GetAlertRequest;
import com.databricks.internal.sdk.service.sql.ListAlertsRequest;
import com.databricks.internal.sdk.service.sql.ListAlertsResponse;
import com.databricks.internal.sdk.service.sql.ListAlertsResponseAlert;
import com.databricks.internal.sdk.service.sql.TrashAlertRequest;
import com.databricks.internal.sdk.service.sql.UpdateAlertRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class AlertsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AlertsAPI.class);
    private final AlertsService impl;

    public AlertsAPI(ApiClient apiClient) {
        this.impl = new AlertsImpl(apiClient);
    }

    public AlertsAPI(AlertsService mock) {
        this.impl = mock;
    }

    public Alert create(CreateAlertRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new TrashAlertRequest().setId(id));
    }

    public void delete(TrashAlertRequest request) {
        this.impl.delete(request);
    }

    public Alert get(String id) {
        return this.get(new GetAlertRequest().setId(id));
    }

    public Alert get(GetAlertRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ListAlertsResponseAlert> list(ListAlertsRequest request) {
        return new Paginator(request, this.impl::list, ListAlertsResponse::getResults, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Alert update(UpdateAlertRequest request) {
        return this.impl.update(request);
    }

    public AlertsService impl() {
        return this.impl;
    }
}

