/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.DatabricksArray;
import com.databricks.jdbc.api.impl.DatabricksStruct;
import com.databricks.jdbc.api.impl.MetadataParser;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatabricksMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksMap.class);

    public DatabricksMap(Map<K, V> map, String metadata) {
        LOGGER.debug("Initializing DatabricksMap with metadata: {}", metadata);
        this.map = this.convertMap(map, metadata);
    }

    private Map<K, V> convertMap(Map<K, V> originalMap, String metadata) {
        LOGGER.debug("Converting map with metadata: {}", metadata);
        LinkedHashMap convertedMap = new LinkedHashMap();
        try {
            String[] mapMetadata = MetadataParser.parseMapMetadata(metadata).split(",", 2);
            String keyType = mapMetadata[0].trim();
            String valueType = mapMetadata[1].trim();
            LOGGER.debug("Parsed metadata - Key Type: {}, Value Type: {}", keyType, valueType);
            for (Map.Entry<K, V> entry : originalMap.entrySet()) {
                Object key = this.convertSimpleValue(entry.getKey(), keyType);
                V value = this.convertValue(entry.getValue(), valueType);
                convertedMap.put(key, value);
                LOGGER.trace("Converted entry - Key: {}, Converted Value: {}", key, value);
            }
        }
        catch (Exception e) {
            LOGGER.error(e, "Error during map conversion: {}", e.getMessage());
            throw new DatabricksDriverException("Invalid metadata or map structure", (Throwable)e, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR);
        }
        return convertedMap;
    }

    private V convertValue(V value, String valueType) {
        try {
            LOGGER.debug("Converting value of type: {}", valueType);
            if (valueType.startsWith("STRUCT")) {
                if (value instanceof Map) {
                    LOGGER.trace("Converting value as STRUCT");
                    return (V)new DatabricksStruct((Map)value, valueType);
                }
                if (value instanceof DatabricksStruct) {
                    return value;
                }
                throw new DatabricksDriverException("Expected a Map for STRUCT but found: " + value.getClass().getSimpleName(), DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR);
            }
            if (valueType.startsWith("ARRAY")) {
                if (value instanceof List) {
                    LOGGER.trace("Converting value as ARRAY");
                    return (V)new DatabricksArray((List)value, valueType);
                }
                if (value instanceof DatabricksArray) {
                    return value;
                }
                throw new DatabricksDriverException("Expected a List for ARRAY but found: " + value.getClass().getSimpleName(), DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR);
            }
            if (valueType.startsWith("MAP")) {
                if (value instanceof Map) {
                    LOGGER.trace("Converting value as MAP");
                    return (V)new DatabricksMap<K, V>((Map)value, valueType);
                }
                if (value instanceof DatabricksMap) {
                    return value;
                }
                throw new DatabricksDriverException("Expected a Map for MAP but found: " + value.getClass().getSimpleName(), DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR);
            }
            return (V)this.convertSimpleValue(value, valueType);
        }
        catch (Exception e) {
            String errorMessage = String.format("Error converting value of type %s: %s", valueType, e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksDriverException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR);
        }
    }

    private <T> T convertSimpleValue(Object value, String valueType) {
        if (value == null) {
            return null;
        }
        try {
            switch (valueType.toUpperCase()) {
                case "INT": {
                    return (T)Integer.valueOf(value.toString());
                }
                case "BIGINT": {
                    return (T)Long.valueOf(value.toString());
                }
                case "SMALLINT": {
                    return (T)Short.valueOf(value.toString());
                }
                case "FLOAT": {
                    return (T)Float.valueOf(value.toString());
                }
                case "DOUBLE": {
                    return (T)Double.valueOf(value.toString());
                }
                case "DECIMAL": {
                    return (T)new BigDecimal(value.toString());
                }
                case "BOOLEAN": {
                    return (T)Boolean.valueOf(value.toString());
                }
                case "DATE": {
                    return (T)Date.valueOf(value.toString());
                }
                case "TIMESTAMP": {
                    return (T)Timestamp.valueOf(value.toString());
                }
                case "TIME": {
                    return (T)Time.valueOf(value.toString());
                }
                case "BINARY": {
                    return (T)(value instanceof byte[] ? value : (Object)value.toString().getBytes());
                }
            }
            return (T)value.toString();
        }
        catch (Exception e) {
            String errorMessage = String.format("Error converting simple value %s of type %s: %s", value, valueType, e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksDriverException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR);
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        this.map.putAll(m4);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(this.formatForJson(entry.getKey())).append(":").append(this.formatForJson(entry.getValue()));
        }
        sb.append("}");
        return sb.toString();
    }

    private String formatForJson(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return "\"" + String.valueOf(obj) + "\"";
        }
        return obj.toString();
    }
}

