/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.common.MetadataResultConstants;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.model.core.ColumnInfoTypeName;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLInterpolator {
    protected static String escapeInputs(String input) {
        int codePoint;
        if (input == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(input.length() + 16);
        out.append("'");
        block7: for (int i = 0; i < input.length(); i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            switch (codePoint) {
                case 39: {
                    out.append("''");
                    continue block7;
                }
                case 92: {
                    out.append("\\\\");
                    continue block7;
                }
                case 10: {
                    out.append("\\n");
                    continue block7;
                }
                case 13: {
                    out.append("\\r");
                    continue block7;
                }
                case 9: {
                    out.append("\\t");
                    continue block7;
                }
            }
            if (codePoint <= 65535) {
                out.append((char)codePoint);
                continue;
            }
            out.append(String.format("\\U%08X", codePoint));
        }
        out.append("'");
        return out.toString();
    }

    private static String formatObject(ImmutableSqlParameter object) {
        if (object == null || object.value() == null) {
            return MetadataResultConstants.NULL_STRING;
        }
        if (object.type() == ColumnInfoTypeName.BINARY) {
            return object.value().toString();
        }
        if (object.value() instanceof String) {
            return SQLInterpolator.escapeInputs(object.value().toString());
        }
        if (object.type() == ColumnInfoTypeName.TIMESTAMP || object.type() == ColumnInfoTypeName.DATE) {
            return "'" + object.value().toString() + "'";
        }
        return object.value().toString();
    }

    private static int countPlaceholders(String sql) {
        int count = 0;
        for (char c : sql.toCharArray()) {
            if (c != '?') continue;
            ++count;
        }
        return count;
    }

    public static String interpolateSQL(String sql, Map<Integer, ImmutableSqlParameter> params) throws DatabricksValidationException {
        String[] parts = sql.split("\\?");
        if (SQLInterpolator.countPlaceholders(sql) != params.size()) {
            throw new DatabricksValidationException("Parameter count does not match. Provide equal number of parameters as placeholders. SQL " + sql);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i >= params.size()) continue;
            sb.append(SQLInterpolator.formatObject(params.get(i + 1)));
        }
        return sb.toString();
    }

    public static String surroundPlaceholdersWithQuotes(String sql) {
        if (sql == null || sql.isEmpty()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m4 = Pattern.compile("(?<!')\\?(?!')").matcher(sql);
        while (m4.find()) {
            m4.appendReplacement(sb, "'?'");
        }
        m4.appendTail(sb);
        return sb.toString();
    }
}

