/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.http;

import com.databricks.internal.apache.http.HttpResponse;
import com.databricks.internal.apache.http.protocol.HttpContext;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpRetryHandler;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;

public class UCVolumeHttpRetryHandler
extends DatabricksHttpRetryHandler {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(UCVolumeHttpRetryHandler.class);
    static final String RETRY_START_TIME_KEY = "retry-start-time";
    private final IDatabricksConnectionContext connectionContext;

    public UCVolumeHttpRetryHandler(IDatabricksConnectionContext connectionContext) {
        super(connectionContext);
        this.connectionContext = connectionContext;
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (!this.isStatusCodeRetryable(statusCode)) {
            return;
        }
        Instant startTime = (Instant)httpContext.getAttribute(RETRY_START_TIME_KEY);
        if (startTime == null) {
            startTime = Instant.now();
            httpContext.setAttribute(RETRY_START_TIME_KEY, startTime);
        }
        int retryInterval = -1;
        if (httpResponse.containsHeader("Retry-After")) {
            retryInterval = Integer.parseInt(httpResponse.getFirstHeader("Retry-After").getValue());
        }
        httpContext.setAttribute("retryInterval", retryInterval);
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        int statusCode = UCVolumeHttpRetryHandler.getErrorCodeFromException(exception);
        if (!this.isStatusCodeRetryable(statusCode)) {
            return false;
        }
        Instant startTime = (Instant)context.getAttribute(RETRY_START_TIME_KEY);
        if (startTime == null) {
            startTime = Instant.now();
        }
        int retryInterval = (Integer)context.getAttribute("retryInterval");
        long delay = UCVolumeHttpRetryHandler.calculateDelay(statusCode, executionCount, retryInterval);
        this.doSleepForDelay(delay);
        long elapsedTime = Duration.between(startTime, Instant.now()).toMillis();
        return elapsedTime <= (long)this.connectionContext.getUCIngestionRetryTimeoutSeconds() * 1000L;
    }

    static long calculateDelay(int errorCode, int executionCount, int retryInterval) {
        switch (errorCode) {
            case 429: 
            case 503: {
                if (retryInterval <= 0) break;
                return retryInterval;
            }
        }
        return UCVolumeHttpRetryHandler.calculateExponentialBackoff(executionCount);
    }

    private boolean isStatusCodeRetryable(int statusCode) {
        return this.connectionContext.getUCIngestionRetriableHttpCodes().contains(statusCode);
    }
}

