/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.pooling;

import com.databricks.jdbc.api.IDatabricksStatement;
import com.databricks.jdbc.api.internal.IDatabricksConnectionInternal;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class DatabricksPooledConnection
implements PooledConnection {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksPooledConnection.class);
    private final Set<ConnectionEventListener> listeners = new CopyOnWriteArraySet<ConnectionEventListener>();
    private Connection physicalConnection;
    private ConnectionHandler connectionHandler;
    private final Object lock = new Object();

    public DatabricksPooledConnection(Connection physicalConnection) {
        this.physicalConnection = physicalConnection;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        LOGGER.debug("public void close()");
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionHandler != null && !this.connectionHandler.isClosed()) {
                this.connectionHandler.close();
            }
            if (this.physicalConnection == null) {
                return;
            }
            try {
                this.physicalConnection.close();
            }
            finally {
                this.physicalConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        LOGGER.debug("public PooledConnection getConnection()");
        Object object = this.lock;
        synchronized (object) {
            if (this.physicalConnection == null) {
                DatabricksSQLException sqlException = new DatabricksSQLException("This PooledConnection has already been closed.", DatabricksDriverErrorCode.CONNECTION_CLOSED);
                this.fireConnectionError(sqlException);
                throw sqlException;
            }
            if (this.connectionHandler != null && !this.connectionHandler.isClosed()) {
                this.connectionHandler.close();
            }
            this.connectionHandler = new ConnectionHandler(this.physicalConnection);
            return this.connectionHandler.getVirtualConnection();
        }
    }

    public Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    private void fireConnectionClosed() {
        LOGGER.debug("void fireConnectionClosed()");
        for (ConnectionEventListener listener : this.listeners) {
            listener.connectionClosed(new ConnectionEvent(this));
        }
    }

    private void fireConnectionError(SQLException e) {
        LOGGER.debug(String.format("private void fireConnectionError(SQLException e = {%s})", e.toString()));
        for (ConnectionEventListener listener : this.listeners) {
            listener.connectionErrorOccurred(new ConnectionEvent(this, e));
        }
    }

    private class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler conHandler;
        private Statement physicalStatement;

        StatementHandler(ConnectionHandler conHandler, Statement physicalStatement) {
            this.conHandler = conHandler;
            this.physicalStatement = physicalStatement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            LOGGER.debug("public Object invoke(Object proxy, Method method = {}, Object[] args = {})", method, Arrays.toString(args));
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("toString")) {
                    return "Pooled statement wrapping physical statement " + String.valueOf(this.physicalStatement);
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                return method.invoke((Object)this.physicalStatement, args);
            }
            if (methodName.equals("isClosed")) {
                StatementHandler statementHandler = this;
                synchronized (statementHandler) {
                    return this.physicalStatement == null || this.physicalStatement.isClosed();
                }
            }
            if (methodName.equals("close")) {
                StatementHandler statementHandler = this;
                synchronized (statementHandler) {
                    if (this.physicalStatement == null || this.physicalStatement.isClosed()) {
                        return null;
                    }
                    this.conHandler = null;
                    this.physicalStatement.close();
                    this.physicalStatement = null;
                }
                return null;
            }
            StatementHandler statementHandler = this;
            synchronized (statementHandler) {
                if (this.physicalStatement == null || this.physicalStatement.isClosed()) {
                    throw new DatabricksSQLException("Statement has been closed.", DatabricksDriverErrorCode.CONNECTION_CLOSED);
                }
            }
            if (methodName.equals("getConnection")) {
                return this.conHandler.getVirtualConnection();
            }
            try {
                return method.invoke((Object)this.physicalStatement, args);
            }
            catch (InvocationTargetException ite) {
                Throwable targetException = ite.getTargetException();
                if (targetException instanceof SQLException) {
                    DatabricksPooledConnection.this.fireConnectionError((SQLException)targetException);
                }
                throw targetException;
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection physicalConnection;
        private Connection virtualConnection;

        ConnectionHandler(Connection physicalConnection) {
            this.physicalConnection = physicalConnection;
            this.virtualConnection = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, IDatabricksConnectionInternal.class}, (InvocationHandler)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, @Nullable Object[] args) throws Throwable {
            LOGGER.debug("public Object invoke(Object proxy, Method method = {}, Object[] args = {})", method, Arrays.toString(args));
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("toString")) {
                    return "Pooled connection wrapping physical connection " + String.valueOf(this.physicalConnection);
                }
                if (methodName.equals("equals")) {
                    return proxy == args[0];
                }
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                try {
                    return method.invoke((Object)this.physicalConnection, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            if (methodName.equals("isClosed")) {
                Object e = DatabricksPooledConnection.this.lock;
                synchronized (e) {
                    return this.physicalConnection == null || this.physicalConnection.isClosed();
                }
            }
            if (methodName.equals("close")) {
                Object e = DatabricksPooledConnection.this.lock;
                synchronized (e) {
                    if (this.physicalConnection != null) {
                        this.physicalConnection = null;
                        this.virtualConnection = null;
                        DatabricksPooledConnection.this.connectionHandler = null;
                        DatabricksPooledConnection.this.fireConnectionClosed();
                    }
                }
                return null;
            }
            Object e = DatabricksPooledConnection.this.lock;
            synchronized (e) {
                if (this.physicalConnection == null || this.physicalConnection.isClosed()) {
                    throw new DatabricksSQLException("Connection has been closed.", DatabricksDriverErrorCode.CONNECTION_CLOSED);
                }
            }
            try {
                Class<Statement> statementClass;
                switch (methodName) {
                    case "createStatement": {
                        statementClass = Statement.class;
                        break;
                    }
                    case "prepareCall": {
                        statementClass = CallableStatement.class;
                        break;
                    }
                    case "prepareStatement": {
                        statementClass = PreparedStatement.class;
                        break;
                    }
                    default: {
                        return method.invoke((Object)this.physicalConnection, args);
                    }
                }
                Statement st = (Statement)method.invoke((Object)this.physicalConnection, args);
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{statementClass, IDatabricksStatement.class}, (InvocationHandler)new StatementHandler(this, st));
            }
            catch (InvocationTargetException ite) {
                Throwable targetException = ite.getTargetException();
                if (targetException instanceof SQLException) {
                    DatabricksPooledConnection.this.fireConnectionError((SQLException)targetException);
                }
                throw targetException;
            }
        }

        Connection getVirtualConnection() {
            return this.virtualConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            LOGGER.debug("public void close()");
            Object object = DatabricksPooledConnection.this.lock;
            synchronized (object) {
                this.physicalConnection = null;
                this.virtualConnection = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosed() {
            Object object = DatabricksPooledConnection.this.lock;
            synchronized (object) {
                return this.physicalConnection == null;
            }
        }
    }
}

