/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.telemetry.CircuitBreakerTelemetryPushClient;
import com.databricks.jdbc.telemetry.ITelemetryClient;
import com.databricks.jdbc.telemetry.ITelemetryPushClient;
import com.databricks.jdbc.telemetry.NoopTelemetryClient;
import com.databricks.jdbc.telemetry.TelemetryClient;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import com.databricks.jdbc.telemetry.TelemetryPushClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TelemetryClientFactory {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(TelemetryClientFactory.class);
    private static final String DEFAULT_HOST = "unknown-host";
    private static final TelemetryClientFactory INSTANCE = new TelemetryClientFactory();
    @VisibleForTesting
    final Map<String, TelemetryClientHolder> telemetryClientHolders = new ConcurrentHashMap<String, TelemetryClientHolder>();
    @VisibleForTesting
    final Map<String, TelemetryClientHolder> noauthTelemetryClientHolders = new ConcurrentHashMap<String, TelemetryClientHolder>();
    private final ExecutorService telemetryExecutorService = Executors.newFixedThreadPool(10, TelemetryClientFactory.createThreadFactory());

    private static ThreadFactory createThreadFactory() {
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Telemetry-Thread-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    private TelemetryClientFactory() {
    }

    public static TelemetryClientFactory getInstance() {
        return INSTANCE;
    }

    public ITelemetryClient getTelemetryClient(IDatabricksConnectionContext connectionContext) {
        if (!TelemetryHelper.isTelemetryAllowedForConnection(connectionContext)) {
            return NoopTelemetryClient.getInstance();
        }
        DatabricksConfig databricksConfig = TelemetryHelper.getDatabricksConfigSafely(connectionContext);
        if (databricksConfig != null) {
            String key = TelemetryClientFactory.keyOf(connectionContext);
            TelemetryClientHolder holder = this.telemetryClientHolders.compute(key, (k, existing) -> {
                if (existing == null) {
                    return new TelemetryClientHolder(new TelemetryClient(connectionContext, this.getTelemetryExecutorService(), databricksConfig), 1);
                }
                existing.refCount.incrementAndGet();
                return existing;
            });
            return holder.client;
        }
        String key = TelemetryClientFactory.keyOf(connectionContext);
        TelemetryClientHolder holder = this.noauthTelemetryClientHolders.compute(key, (k, existing) -> {
            if (existing == null) {
                return new TelemetryClientHolder(new TelemetryClient(connectionContext, this.getTelemetryExecutorService()), 1);
            }
            existing.refCount.incrementAndGet();
            return existing;
        });
        return holder.client;
    }

    public void closeTelemetryClient(IDatabricksConnectionContext connectionContext) {
        String key = TelemetryClientFactory.keyOf(connectionContext);
        this.telemetryClientHolders.computeIfPresent(key, (k, holder) -> {
            if (holder.refCount.get() <= 1) {
                this.closeTelemetryClient(holder.client, "telemetry client");
                return null;
            }
            holder.refCount.decrementAndGet();
            return holder;
        });
        this.noauthTelemetryClientHolders.computeIfPresent(key, (k, holder) -> {
            if (holder.refCount.get() <= 1) {
                this.closeTelemetryClient(holder.client, "unauthenticated telemetry client");
                return null;
            }
            holder.refCount.decrementAndGet();
            return holder;
        });
    }

    public ExecutorService getTelemetryExecutorService() {
        return this.telemetryExecutorService;
    }

    static ITelemetryPushClient getTelemetryPushClient(Boolean isAuthenticated, IDatabricksConnectionContext connectionContext, DatabricksConfig databricksConfig) {
        ITelemetryPushClient pushClient = new TelemetryPushClient(isAuthenticated, connectionContext, databricksConfig);
        if (connectionContext.isTelemetryCircuitBreakerEnabled()) {
            String host = null;
            try {
                host = connectionContext.getHostUrl();
            }
            catch (DatabricksParsingException e) {
                LOGGER.error(e, "Error parsing host url");
                host = DEFAULT_HOST;
            }
            pushClient = new CircuitBreakerTelemetryPushClient(pushClient, host);
        }
        return pushClient;
    }

    @VisibleForTesting
    public void reset() {
        this.telemetryClientHolders.values().forEach(holder -> holder.client.close());
        this.noauthTelemetryClientHolders.values().forEach(holder -> holder.client.close());
        this.telemetryClientHolders.clear();
        this.noauthTelemetryClientHolders.clear();
    }

    private void closeTelemetryClient(ITelemetryClient client, String clientType) {
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception e) {
                LOGGER.debug("Caught error while closing {}. Error: {}", clientType, e);
            }
        }
    }

    private static String keyOf(IDatabricksConnectionContext context) {
        return context.getHostForOAuth();
    }

    private static final class TelemetryClientHolder {
        final TelemetryClient client;
        final AtomicInteger refCount;

        TelemetryClientHolder(TelemetryClient client, int initialCount) {
            this.client = client;
            this.refCount = new AtomicInteger(initialCount);
        }
    }
}

