// Code generated from OpenAPI specs by Databricks SDK Generator. DO NOT EDIT.

package com.databricks.sdk.service.ml;

import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.ToStringer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;

@Generated
public class CreateModelVersionRequest {
  /** Optional description for model version. */
  @JsonProperty("description")
  private String description;

  /** Register model under this name */
  @JsonProperty("name")
  private String name;

  /**
   * MLflow run ID for correlation, if `source` was generated by an experiment run in MLflow
   * tracking server
   */
  @JsonProperty("run_id")
  private String runId;

  /**
   * MLflow run link - this is the exact link of the run that generated this model version,
   * potentially hosted at another instance of MLflow.
   */
  @JsonProperty("run_link")
  private String runLink;

  /** URI indicating the location of the model artifacts. */
  @JsonProperty("source")
  private String source;

  /** Additional metadata for model version. */
  @JsonProperty("tags")
  private Collection<ModelVersionTag> tags;

  public CreateModelVersionRequest setDescription(String description) {
    this.description = description;
    return this;
  }

  public String getDescription() {
    return description;
  }

  public CreateModelVersionRequest setName(String name) {
    this.name = name;
    return this;
  }

  public String getName() {
    return name;
  }

  public CreateModelVersionRequest setRunId(String runId) {
    this.runId = runId;
    return this;
  }

  public String getRunId() {
    return runId;
  }

  public CreateModelVersionRequest setRunLink(String runLink) {
    this.runLink = runLink;
    return this;
  }

  public String getRunLink() {
    return runLink;
  }

  public CreateModelVersionRequest setSource(String source) {
    this.source = source;
    return this;
  }

  public String getSource() {
    return source;
  }

  public CreateModelVersionRequest setTags(Collection<ModelVersionTag> tags) {
    this.tags = tags;
    return this;
  }

  public Collection<ModelVersionTag> getTags() {
    return tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CreateModelVersionRequest that = (CreateModelVersionRequest) o;
    return Objects.equals(description, that.description)
        && Objects.equals(name, that.name)
        && Objects.equals(runId, that.runId)
        && Objects.equals(runLink, that.runLink)
        && Objects.equals(source, that.source)
        && Objects.equals(tags, that.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, name, runId, runLink, source, tags);
  }

  @Override
  public String toString() {
    return new ToStringer(CreateModelVersionRequest.class)
        .add("description", description)
        .add("name", name)
        .add("runId", runId)
        .add("runLink", runLink)
        .add("source", source)
        .add("tags", tags)
        .toString();
  }
}
