/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.AzureEnvironment;
import com.databricks.sdk.core.ConfigAttribute;
import com.databricks.sdk.core.ConfigLoader;
import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.DefaultCredentialsProvider;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.commons.CommonsHttpClient;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.HttpMessage;

public class DatabricksConfig {
    public static final String DEFAULT_CONFIG_FILE = "~/.databrickscfg";
    private CredentialsProvider credentialsProvider = new DefaultCredentialsProvider();
    @ConfigAttribute(value="host", env="DATABRICKS_HOST")
    private String host;
    @ConfigAttribute(value="account_id", env="DATABRICKS_ACCOUNT_ID")
    private String accountId;
    @ConfigAttribute(value="token", env="DATABRICKS_TOKEN", auth="pat", sensitive=true)
    private String token;
    @ConfigAttribute(value="client_id", env="DATABRICKS_CLIENT_ID", auth="oauth")
    private String clientId;
    @ConfigAttribute(value="client_secret", env="DATABRICKS_CLIENT_SECRET", auth="oauth", sensitive=true)
    private String clientSecret;
    @ConfigAttribute(value="username", env="DATABRICKS_USERNAME", auth="basic")
    private String username;
    @ConfigAttribute(value="password", env="DATABRICKS_PASSWORD", auth="basic", sensitive=true)
    private String password;
    @ConfigAttribute(value="profile", env="DATABRICKS_CONFIG_PROFILE")
    private String profile;
    @ConfigAttribute(value="config_file", env="DATABRICKS_CONFIG_FILE")
    private String configFile;
    @ConfigAttribute(value="google_service_account", env="DATABRICKS_GOOGLE_SERVICE_ACCOUNT", auth="google")
    private String googleServiceAccount;
    @ConfigAttribute(value="google_credentials", env="GOOGLE_CREDENTIALS", auth="google", sensitive=true)
    private String googleCredentials;
    @ConfigAttribute(value="azure_workspace_resource_id", env="DATABRICKS_AZURE_RESOURCE_ID", auth="azure")
    private String azureWorkspaceResourceId;
    @ConfigAttribute(value="azure_use_msi", env="ARM_USE_MSI", auth="azure")
    private Boolean azureUseMSI;
    @ConfigAttribute(value="azure_client_secret", env="ARM_CLIENT_SECRET", auth="azure", sensitive=true)
    private String azureClientSecret;
    @ConfigAttribute(value="azure_client_id", env="ARM_CLIENT_ID", auth="azure")
    private String azureClientId;
    @ConfigAttribute(value="azure_tenant_id", env="ARM_TENANT_ID", auth="azure")
    private String azureTenantId;
    @ConfigAttribute(value="azure_environment", env="ARM_ENVIRONMENT")
    private String azureEnvironment;
    @ConfigAttribute(value="azure_login_app_id", env="DATABRICKS_AZURE_LOGIN_APP_ID", auth="azure")
    private String azureLoginAppId;
    @ConfigAttribute(value="bricks_cli_path", env="BRICKS_CLI_PATH")
    private String bricksCliPath;
    @ConfigAttribute(value="auth_type", env="DATABRICKS_AUTH_TYPE")
    private String authType;
    @ConfigAttribute(value="skip_verify")
    private Boolean skipVerify;
    @ConfigAttribute(value="http_timeout_seconds")
    private Integer httpTimeoutSeconds;
    @ConfigAttribute(value="debug_truncate_bytes", env="DATABRICKS_DEBUG_TRUNCATE_BYTES")
    private Integer debugTruncateBytes;
    @ConfigAttribute(value="debug_headers", env="DATABRICKS_DEBUG_HEADERS")
    private Boolean debugHeaders;
    @ConfigAttribute(value="rate_limit", env="DATABRICKS_RATE_LIMIT")
    private Integer rateLimit;
    private volatile boolean resolved;
    private HeaderFactory headerFactory;
    private HttpClient httpClient;
    private Map<String, String> allEnv;

    public Map<String, String> getAllEnv() {
        return this.allEnv;
    }

    public synchronized DatabricksConfig resolve() {
        return this.resolve(System::getenv);
    }

    synchronized DatabricksConfig resolve(Supplier<Map<String, String>> getAllEnv) {
        this.allEnv = getAllEnv.get();
        this.innerResolve();
        return this;
    }

    private synchronized DatabricksConfig innerResolve() {
        Objects.requireNonNull(this.allEnv);
        try {
            ConfigLoader.resolve(this);
            ConfigLoader.validate(this);
            ConfigLoader.fixHostIfNeeded(this);
            this.initHttp();
            return this;
        }
        catch (DatabricksException e) {
            throw ConfigLoader.makeNicerError(e.getMessage(), e, this);
        }
    }

    private void initHttp() {
        if (this.httpClient != null) {
            return;
        }
        int timeout = 300;
        if (this.httpTimeoutSeconds != null) {
            timeout = this.httpTimeoutSeconds;
        }
        this.httpClient = new CommonsHttpClient(timeout);
    }

    public synchronized Map<String, String> authenticate() throws DatabricksException {
        try {
            if (this.headerFactory == null) {
                ConfigLoader.fixHostIfNeeded(this);
                this.headerFactory = this.credentialsProvider.configure(this);
                this.setAuthType(this.credentialsProvider.authType());
            }
            return this.headerFactory.headers();
        }
        catch (DatabricksException e) {
            String msg = String.format("%s auth: %s", this.credentialsProvider.authType(), e.getMessage());
            DatabricksException wrapperException = new DatabricksException(msg, e);
            throw ConfigLoader.makeNicerError(wrapperException.getMessage(), wrapperException, this);
        }
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public DatabricksConfig setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public DatabricksConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public DatabricksConfig setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getBricksCliPath() {
        return this.bricksCliPath;
    }

    public DatabricksConfig setBricksCliPath(String bricksCliPath) {
        this.bricksCliPath = bricksCliPath;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public DatabricksConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public DatabricksConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DatabricksConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public DatabricksConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public DatabricksConfig setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getProfile() {
        return this.profile;
    }

    public DatabricksConfig setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public DatabricksConfig setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public String getGoogleServiceAccount() {
        return this.googleServiceAccount;
    }

    public DatabricksConfig setGoogleServiceAccount(String googleServiceAccount) {
        this.googleServiceAccount = googleServiceAccount;
        return this;
    }

    public String getGoogleCredentials() {
        return this.googleCredentials;
    }

    public DatabricksConfig setGoogleCredentials(String googleCredentials) {
        this.googleCredentials = googleCredentials;
        return this;
    }

    public String getAzureWorkspaceResourceId() {
        return this.azureWorkspaceResourceId;
    }

    public DatabricksConfig setAzureWorkspaceResourceId(String azureWorkspaceResourceId) {
        this.azureWorkspaceResourceId = azureWorkspaceResourceId;
        return this;
    }

    public boolean isAzureUseMSI() {
        return this.azureUseMSI;
    }

    public DatabricksConfig setAzureUseMSI(boolean azureUseMSI) {
        this.azureUseMSI = azureUseMSI;
        return this;
    }

    public String getAzureClientSecret() {
        return this.azureClientSecret;
    }

    public DatabricksConfig setAzureClientSecret(String azureClientSecret) {
        this.azureClientSecret = azureClientSecret;
        return this;
    }

    public String getAzureClientId() {
        return this.azureClientId;
    }

    public DatabricksConfig setAzureClientId(String azureClientId) {
        this.azureClientId = azureClientId;
        return this;
    }

    public String getAzureTenantId() {
        return this.azureTenantId;
    }

    public DatabricksConfig setAzureTenantId(String azureTenantId) {
        this.azureTenantId = azureTenantId;
        return this;
    }

    public AzureEnvironment getAzureEnvironment() {
        String env = "PUBLIC";
        if (this.azureEnvironment != null) {
            env = this.azureEnvironment;
        }
        return AzureEnvironment.getEnvironment(env);
    }

    public DatabricksConfig setAzureEnvironment(String azureEnvironment) {
        this.azureEnvironment = azureEnvironment;
        return this;
    }

    public String getEffectiveAzureLoginAppId() {
        if (this.azureLoginAppId != null) {
            return this.azureLoginAppId;
        }
        return "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d";
    }

    public String getAuthType() {
        return this.authType;
    }

    public DatabricksConfig setAuthType(String authType) {
        this.authType = authType;
        return this;
    }

    public boolean isSkipVerify() {
        return this.skipVerify;
    }

    public DatabricksConfig setSkipVerify(boolean skipVerify) {
        this.skipVerify = skipVerify;
        return this;
    }

    public Integer getHttpTimeoutSeconds() {
        return this.httpTimeoutSeconds;
    }

    public DatabricksConfig setHttpTimeoutSeconds(int httpTimeoutSeconds) {
        this.httpTimeoutSeconds = httpTimeoutSeconds;
        return this;
    }

    public Integer getDebugTruncateBytes() {
        return this.debugTruncateBytes;
    }

    public DatabricksConfig setDebugTruncateBytes(int debugTruncateBytes) {
        this.debugTruncateBytes = debugTruncateBytes;
        return this;
    }

    public boolean isDebugHeaders() {
        return this.debugHeaders != null && this.debugHeaders != false;
    }

    public DatabricksConfig setDebugHeaders(boolean debugHeaders) {
        this.debugHeaders = debugHeaders;
        return this;
    }

    public Integer getRateLimit() {
        return this.rateLimit;
    }

    public DatabricksConfig setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public DatabricksConfig setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public boolean isAzure() {
        if (this.azureWorkspaceResourceId != null) {
            return true;
        }
        if (this.host == null) {
            return false;
        }
        return this.host.contains(".azuredatabricks.");
    }

    public synchronized void authenticate(HttpMessage request) {
        Map<String, String> headers = this.authenticate();
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.setHeader(e.getKey(), e.getValue());
        }
    }

    public boolean isGcp() {
        if (this.host == null) {
            return false;
        }
        return this.host.contains(".gcp.databricks.com");
    }

    public boolean isAws() {
        if (this.host == null) {
            return false;
        }
        return !this.isAzure() && !this.isGcp();
    }

    public boolean isAccountClient() {
        if (this.host == null) {
            return false;
        }
        return this.host.contains("https://accounts.");
    }

    public OpenIDConnectEndpoints getOidcEndpoints() throws IOException {
        if (this.getHost() == null) {
            return null;
        }
        if (this.isAzure()) {
            Response resp = this.getHttpClient().execute(new Request("GET", this.getHost() + "/oidc/oauth2/v2.0/authorize"));
            String realAuthUrl = resp.getFirstHeader("location");
            if (realAuthUrl == null) {
                return null;
            }
            return new OpenIDConnectEndpoints(realAuthUrl.replaceAll("/authorize", "/token"), realAuthUrl);
        }
        if (this.getAccountId() != null) {
            String prefix = this.getHost() + "/oidc/accounts/" + this.getAccountId();
            return new OpenIDConnectEndpoints(prefix + "/v1/token", prefix + "/v1/authorize");
        }
        String oidcEndpoint = this.getHost() + "/oidc/.well-known/oauth-authorization-server";
        Response resp = this.getHttpClient().execute(new Request("GET", oidcEndpoint));
        if (resp.getStatusCode() != 200) {
            return null;
        }
        return (OpenIDConnectEndpoints)new ObjectMapper().readValue(resp.getBody(), OpenIDConnectEndpoints.class);
    }

    public String toString() {
        return ConfigLoader.debugString(this);
    }
}

