/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.commons;

import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class CommonsHttpClient
implements HttpClient {
    private final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private final CloseableHttpClient hc;
    private int timeout;

    public CommonsHttpClient(int timeoutSeconds) {
        this.timeout = timeoutSeconds * 1000;
        this.connectionManager.setMaxTotal(100);
        this.hc = this.makeClosableHttpClient();
    }

    private RequestConfig makeRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(this.timeout).setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).build();
    }

    private CloseableHttpClient makeClosableHttpClient() {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setDefaultRequestConfig(this.makeRequestConfig()).build();
    }

    @Override
    public Response execute(Request in) throws IOException {
        HttpUriRequest request = this.transformRequest(in);
        in.getHeaders().forEach((arg_0, arg_1) -> ((HttpUriRequest)request).setHeader(arg_0, arg_1));
        try (CloseableHttpResponse response = this.hc.execute(request);){
            HttpEntity entity = response.getEntity();
            StatusLine statusLine = response.getStatusLine();
            Map<String, List<String>> hs = Arrays.stream(response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
            String body = null;
            if (entity != null) {
                try (InputStream inputStream = entity.getContent();){
                    body = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                }
            }
            Response response2 = new Response(in, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs, body);
            return response2;
        }
    }

    private HttpUriRequest transformRequest(Request in) {
        switch (in.getMethod()) {
            case "GET": {
                return new HttpGet(in.getUri());
            }
            case "DELETE": {
                return new HttpDelete(in.getUri());
            }
            case "POST": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPost(in.getUri()), in.getBody());
            }
            case "PUT": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPut(in.getUri()), in.getBody());
            }
            case "PATCH": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPatch(in.getUri()), in.getBody());
            }
        }
        throw new IllegalArgumentException("Unknown method: " + in.getMethod());
    }

    private HttpRequestBase withEntity(HttpEntityEnclosingRequestBase request, String body) {
        try {
            request.setEntity((HttpEntity)new StringEntity(body));
            return request;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

