/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountMetastoresImpl;
import com.databricks.sdk.service.catalog.AccountMetastoresService;
import com.databricks.sdk.service.catalog.CreateMetastore;
import com.databricks.sdk.service.catalog.DeleteAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.GetAccountMetastoreRequest;
import com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.service.catalog.UpdateMetastore;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountMetastoresAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountMetastoresAPI.class);
    private final AccountMetastoresService impl;

    public AccountMetastoresAPI(ApiClient apiClient) {
        this.impl = new AccountMetastoresImpl(apiClient);
    }

    public AccountMetastoresAPI(AccountMetastoresService mock) {
        this.impl = mock;
    }

    public MetastoreInfo create(String name, String storageRoot) {
        return this.create(new CreateMetastore().setName(name).setStorageRoot(storageRoot));
    }

    public MetastoreInfo create(CreateMetastore request) {
        return this.impl.create(request);
    }

    public void delete(String metastoreId) {
        this.delete(new DeleteAccountMetastoreRequest().setMetastoreId(metastoreId));
    }

    public void delete(DeleteAccountMetastoreRequest request) {
        this.impl.delete(request);
    }

    public MetastoreInfo get(String metastoreId) {
        return this.get(new GetAccountMetastoreRequest().setMetastoreId(metastoreId));
    }

    public MetastoreInfo get(GetAccountMetastoreRequest request) {
        return this.impl.get(request);
    }

    public ListMetastoresResponse list() {
        return this.impl.list();
    }

    public MetastoreInfo update(String metastoreId, String id) {
        return this.update(new UpdateMetastore().setMetastoreId(metastoreId).setId(id));
    }

    public MetastoreInfo update(UpdateMetastore request) {
        return this.impl.update(request);
    }

    public AccountMetastoresService impl() {
        return this.impl;
    }
}

