/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsImpl;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.sdk.service.catalog.CreateStorageCredential;
import com.databricks.sdk.service.catalog.GetAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.ListAccountStorageCredentialsRequest;
import com.databricks.sdk.service.catalog.StorageCredentialInfo;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountStorageCredentialsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountStorageCredentialsAPI.class);
    private final AccountStorageCredentialsService impl;

    public AccountStorageCredentialsAPI(ApiClient apiClient) {
        this.impl = new AccountStorageCredentialsImpl(apiClient);
    }

    public AccountStorageCredentialsAPI(AccountStorageCredentialsService mock) {
        this.impl = mock;
    }

    public StorageCredentialInfo create(String name, String metastoreId) {
        return this.create(new CreateStorageCredential().setName(name).setMetastoreId(metastoreId));
    }

    public StorageCredentialInfo create(CreateStorageCredential request) {
        return this.impl.create(request);
    }

    public StorageCredentialInfo get(String metastoreId, String name) {
        return this.get(new GetAccountStorageCredentialRequest().setMetastoreId(metastoreId).setName(name));
    }

    public StorageCredentialInfo get(GetAccountStorageCredentialRequest request) {
        return this.impl.get(request);
    }

    public Iterable<StorageCredentialInfo> list(String metastoreId) {
        return this.list(new ListAccountStorageCredentialsRequest().setMetastoreId(metastoreId));
    }

    public Iterable<StorageCredentialInfo> list(ListAccountStorageCredentialsRequest request) {
        return this.impl.list(request);
    }

    public AccountStorageCredentialsService impl() {
        return this.impl;
    }
}

