/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.AccountGroupsImpl;
import com.databricks.sdk.service.iam.AccountGroupsService;
import com.databricks.sdk.service.iam.DeleteAccountGroupRequest;
import com.databricks.sdk.service.iam.GetAccountGroupRequest;
import com.databricks.sdk.service.iam.Group;
import com.databricks.sdk.service.iam.ListAccountGroupsRequest;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountGroupsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountGroupsAPI.class);
    private final AccountGroupsService impl;

    public AccountGroupsAPI(ApiClient apiClient) {
        this.impl = new AccountGroupsImpl(apiClient);
    }

    public AccountGroupsAPI(AccountGroupsService mock) {
        this.impl = mock;
    }

    public Group create(String id) {
        return this.create(new Group().setId(id));
    }

    public Group create(Group request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteAccountGroupRequest().setId(id));
    }

    public void delete(DeleteAccountGroupRequest request) {
        this.impl.delete(request);
    }

    public Group get(String id) {
        return this.get(new GetAccountGroupRequest().setId(id));
    }

    public Group get(GetAccountGroupRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Group> list(ListAccountGroupsRequest request) {
        return this.impl.list(request).getResources();
    }

    public void patch(String id) {
        this.patch(new PartialUpdate().setId(id));
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public void update(String id) {
        this.update(new Group().setId(id));
    }

    public void update(Group request) {
        this.impl.update(request);
    }

    public AccountGroupsService impl() {
        return this.impl;
    }
}

