/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.ml.CreateExperiment;
import com.databricks.sdk.service.ml.CreateExperimentResponse;
import com.databricks.sdk.service.ml.CreateRun;
import com.databricks.sdk.service.ml.CreateRunResponse;
import com.databricks.sdk.service.ml.DeleteExperiment;
import com.databricks.sdk.service.ml.DeleteRun;
import com.databricks.sdk.service.ml.DeleteTag;
import com.databricks.sdk.service.ml.Experiment;
import com.databricks.sdk.service.ml.ExperimentsImpl;
import com.databricks.sdk.service.ml.ExperimentsService;
import com.databricks.sdk.service.ml.FileInfo;
import com.databricks.sdk.service.ml.GetByNameRequest;
import com.databricks.sdk.service.ml.GetExperimentByNameResponse;
import com.databricks.sdk.service.ml.GetExperimentRequest;
import com.databricks.sdk.service.ml.GetHistoryRequest;
import com.databricks.sdk.service.ml.GetMetricHistoryResponse;
import com.databricks.sdk.service.ml.GetRunRequest;
import com.databricks.sdk.service.ml.GetRunResponse;
import com.databricks.sdk.service.ml.ListArtifactsRequest;
import com.databricks.sdk.service.ml.ListArtifactsResponse;
import com.databricks.sdk.service.ml.ListExperimentsRequest;
import com.databricks.sdk.service.ml.ListExperimentsResponse;
import com.databricks.sdk.service.ml.LogBatch;
import com.databricks.sdk.service.ml.LogMetric;
import com.databricks.sdk.service.ml.LogModel;
import com.databricks.sdk.service.ml.LogParam;
import com.databricks.sdk.service.ml.RestoreExperiment;
import com.databricks.sdk.service.ml.RestoreRun;
import com.databricks.sdk.service.ml.Run;
import com.databricks.sdk.service.ml.SearchExperiments;
import com.databricks.sdk.service.ml.SearchExperimentsResponse;
import com.databricks.sdk.service.ml.SearchRuns;
import com.databricks.sdk.service.ml.SearchRunsResponse;
import com.databricks.sdk.service.ml.SetExperimentTag;
import com.databricks.sdk.service.ml.SetTag;
import com.databricks.sdk.service.ml.UpdateExperiment;
import com.databricks.sdk.service.ml.UpdateRun;
import com.databricks.sdk.service.ml.UpdateRunResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ExperimentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentsAPI.class);
    private final ExperimentsService impl;

    public ExperimentsAPI(ApiClient apiClient) {
        this.impl = new ExperimentsImpl(apiClient);
    }

    public ExperimentsAPI(ExperimentsService mock) {
        this.impl = mock;
    }

    public CreateExperimentResponse createExperiment(String name) {
        return this.createExperiment(new CreateExperiment().setName(name));
    }

    public CreateExperimentResponse createExperiment(CreateExperiment request) {
        return this.impl.createExperiment(request);
    }

    public CreateRunResponse createRun(CreateRun request) {
        return this.impl.createRun(request);
    }

    public void deleteExperiment(String experimentId) {
        this.deleteExperiment(new DeleteExperiment().setExperimentId(experimentId));
    }

    public void deleteExperiment(DeleteExperiment request) {
        this.impl.deleteExperiment(request);
    }

    public void deleteRun(String runId) {
        this.deleteRun(new DeleteRun().setRunId(runId));
    }

    public void deleteRun(DeleteRun request) {
        this.impl.deleteRun(request);
    }

    public void deleteTag(String runId, String key) {
        this.deleteTag(new DeleteTag().setRunId(runId).setKey(key));
    }

    public void deleteTag(DeleteTag request) {
        this.impl.deleteTag(request);
    }

    public GetExperimentByNameResponse getByName(String experimentName) {
        return this.getByName(new GetByNameRequest().setExperimentName(experimentName));
    }

    public GetExperimentByNameResponse getByName(GetByNameRequest request) {
        return this.impl.getByName(request);
    }

    public Experiment getExperiment(String experimentId) {
        return this.getExperiment(new GetExperimentRequest().setExperimentId(experimentId));
    }

    public Experiment getExperiment(GetExperimentRequest request) {
        return this.impl.getExperiment(request);
    }

    public GetMetricHistoryResponse getHistory(String metricKey) {
        return this.getHistory(new GetHistoryRequest().setMetricKey(metricKey));
    }

    public GetMetricHistoryResponse getHistory(GetHistoryRequest request) {
        return this.impl.getHistory(request);
    }

    public GetRunResponse getRun(String runId) {
        return this.getRun(new GetRunRequest().setRunId(runId));
    }

    public GetRunResponse getRun(GetRunRequest request) {
        return this.impl.getRun(request);
    }

    public Iterable<FileInfo> listArtifacts(ListArtifactsRequest request) {
        return new Paginator(request, this.impl::listArtifacts, ListArtifactsResponse::getFiles, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Experiment> listExperiments(ListExperimentsRequest request) {
        return new Paginator(request, this.impl::listExperiments, ListExperimentsResponse::getExperiments, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void logBatch(LogBatch request) {
        this.impl.logBatch(request);
    }

    public void logMetric(String key, float value, long timestamp) {
        this.logMetric(new LogMetric().setKey(key).setValue(Float.valueOf(value)).setTimestamp(timestamp));
    }

    public void logMetric(LogMetric request) {
        this.impl.logMetric(request);
    }

    public void logModel(LogModel request) {
        this.impl.logModel(request);
    }

    public void logParam(String key, String value) {
        this.logParam(new LogParam().setKey(key).setValue(value));
    }

    public void logParam(LogParam request) {
        this.impl.logParam(request);
    }

    public void restoreExperiment(String experimentId) {
        this.restoreExperiment(new RestoreExperiment().setExperimentId(experimentId));
    }

    public void restoreExperiment(RestoreExperiment request) {
        this.impl.restoreExperiment(request);
    }

    public void restoreRun(String runId) {
        this.restoreRun(new RestoreRun().setRunId(runId));
    }

    public void restoreRun(RestoreRun request) {
        this.impl.restoreRun(request);
    }

    public Iterable<Experiment> searchExperiments(SearchExperiments request) {
        return new Paginator(request, this.impl::searchExperiments, SearchExperimentsResponse::getExperiments, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<Run> searchRuns(SearchRuns request) {
        return new Paginator(request, this.impl::searchRuns, SearchRunsResponse::getRuns, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public void setExperimentTag(String experimentId, String key, String value) {
        this.setExperimentTag(new SetExperimentTag().setExperimentId(experimentId).setKey(key).setValue(value));
    }

    public void setExperimentTag(SetExperimentTag request) {
        this.impl.setExperimentTag(request);
    }

    public void setTag(String key, String value) {
        this.setTag(new SetTag().setKey(key).setValue(value));
    }

    public void setTag(SetTag request) {
        this.impl.setTag(request);
    }

    public void updateExperiment(String experimentId) {
        this.updateExperiment(new UpdateExperiment().setExperimentId(experimentId));
    }

    public void updateExperiment(UpdateExperiment request) {
        this.impl.updateExperiment(request);
    }

    public UpdateRunResponse updateRun(UpdateRun request) {
        return this.impl.updateRun(request);
    }

    public ExperimentsService impl() {
        return this.impl;
    }
}

