/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.PermissionsList;
import com.databricks.sdk.service.sharing.CreateShare;
import com.databricks.sdk.service.sharing.DeleteShareRequest;
import com.databricks.sdk.service.sharing.GetShareRequest;
import com.databricks.sdk.service.sharing.ListSharesResponse;
import com.databricks.sdk.service.sharing.ShareInfo;
import com.databricks.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.sdk.service.sharing.SharesService;
import com.databricks.sdk.service.sharing.UpdateShare;
import com.databricks.sdk.service.sharing.UpdateSharePermissions;
import com.databricks.sdk.support.Generated;

@Generated
class SharesImpl
implements SharesService {
    private final ApiClient apiClient;

    public SharesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ShareInfo create(CreateShare request) {
        String path = "/api/2.1/unity-catalog/shares";
        return this.apiClient.POST(path, request, ShareInfo.class);
    }

    @Override
    public void delete(DeleteShareRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public ShareInfo get(GetShareRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        return this.apiClient.GET(path, request, ShareInfo.class);
    }

    @Override
    public ListSharesResponse list() {
        String path = "/api/2.1/unity-catalog/shares";
        return this.apiClient.GET(path, ListSharesResponse.class);
    }

    @Override
    public PermissionsList sharePermissions(SharePermissionsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s/permissions", request.getName());
        return this.apiClient.GET(path, request, PermissionsList.class);
    }

    @Override
    public ShareInfo update(UpdateShare request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        return this.apiClient.PATCH(path, request, ShareInfo.class);
    }

    @Override
    public void updatePermissions(UpdateSharePermissions request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s/permissions", request.getName());
        this.apiClient.PATCH(path, request, Void.class);
    }
}

