/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateFunction;
import com.databricks.sdk.service.catalog.CreateFunctionRequest;
import com.databricks.sdk.service.catalog.DeleteFunctionRequest;
import com.databricks.sdk.service.catalog.FunctionInfo;
import com.databricks.sdk.service.catalog.FunctionsImpl;
import com.databricks.sdk.service.catalog.FunctionsService;
import com.databricks.sdk.service.catalog.GetFunctionRequest;
import com.databricks.sdk.service.catalog.ListFunctionsRequest;
import com.databricks.sdk.service.catalog.UpdateFunction;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class FunctionsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionsAPI.class);
    private final FunctionsService impl;

    public FunctionsAPI(ApiClient apiClient) {
        this.impl = new FunctionsImpl(apiClient);
    }

    public FunctionsAPI(FunctionsService mock) {
        this.impl = mock;
    }

    public FunctionInfo create(CreateFunction functionInfo) {
        return this.create(new CreateFunctionRequest().setFunctionInfo(functionInfo));
    }

    public FunctionInfo create(CreateFunctionRequest request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteFunctionRequest().setName(name));
    }

    public void delete(DeleteFunctionRequest request) {
        this.impl.delete(request);
    }

    public FunctionInfo get(String name) {
        return this.get(new GetFunctionRequest().setName(name));
    }

    public FunctionInfo get(GetFunctionRequest request) {
        return this.impl.get(request);
    }

    public Iterable<FunctionInfo> list(String catalogName, String schemaName) {
        return this.list(new ListFunctionsRequest().setCatalogName(catalogName).setSchemaName(schemaName));
    }

    public Iterable<FunctionInfo> list(ListFunctionsRequest request) {
        return this.impl.list(request).getFunctions();
    }

    public FunctionInfo update(String name) {
        return this.update(new UpdateFunction().setName(name));
    }

    public FunctionInfo update(UpdateFunction request) {
        return this.impl.update(request);
    }

    public FunctionsService impl() {
        return this.impl;
    }
}

