/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateVolumeRequestContent;
import com.databricks.sdk.service.catalog.DeleteVolumeRequest;
import com.databricks.sdk.service.catalog.ListVolumesRequest;
import com.databricks.sdk.service.catalog.ReadVolumeRequest;
import com.databricks.sdk.service.catalog.UpdateVolumeRequestContent;
import com.databricks.sdk.service.catalog.VolumeInfo;
import com.databricks.sdk.service.catalog.VolumeType;
import com.databricks.sdk.service.catalog.VolumesImpl;
import com.databricks.sdk.service.catalog.VolumesService;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class VolumesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(VolumesAPI.class);
    private final VolumesService impl;

    public VolumesAPI(ApiClient apiClient) {
        this.impl = new VolumesImpl(apiClient);
    }

    public VolumesAPI(VolumesService mock) {
        this.impl = mock;
    }

    public VolumeInfo create(String catalogName, String schemaName, String name, VolumeType volumeType) {
        return this.create(new CreateVolumeRequestContent().setCatalogName(catalogName).setSchemaName(schemaName).setName(name).setVolumeType(volumeType));
    }

    public VolumeInfo create(CreateVolumeRequestContent request) {
        return this.impl.create(request);
    }

    public void delete(String fullNameArg) {
        this.delete(new DeleteVolumeRequest().setFullNameArg(fullNameArg));
    }

    public void delete(DeleteVolumeRequest request) {
        this.impl.delete(request);
    }

    public Iterable<VolumeInfo> list(String catalogName, String schemaName) {
        return this.list(new ListVolumesRequest().setCatalogName(catalogName).setSchemaName(schemaName));
    }

    public Iterable<VolumeInfo> list(ListVolumesRequest request) {
        return this.impl.list(request).getVolumes();
    }

    public VolumeInfo read(String fullNameArg) {
        return this.read(new ReadVolumeRequest().setFullNameArg(fullNameArg));
    }

    public VolumeInfo read(ReadVolumeRequest request) {
        return this.impl.read(request);
    }

    public VolumeInfo update(String fullNameArg) {
        return this.update(new UpdateVolumeRequestContent().setFullNameArg(fullNameArg));
    }

    public VolumeInfo update(UpdateVolumeRequestContent request) {
        return this.impl.update(request);
    }

    public VolumesService impl() {
        return this.impl;
    }
}

