/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.serving;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.serving.AppsService;
import com.databricks.sdk.service.serving.DeleteAppRequest;
import com.databricks.sdk.service.serving.DeleteAppResponse;
import com.databricks.sdk.service.serving.DeployAppRequest;
import com.databricks.sdk.service.serving.DeploymentStatus;
import com.databricks.sdk.service.serving.GetAppDeploymentStatusRequest;
import com.databricks.sdk.service.serving.GetAppRequest;
import com.databricks.sdk.service.serving.GetAppResponse;
import com.databricks.sdk.service.serving.GetEventsRequest;
import com.databricks.sdk.service.serving.ListAppEventsResponse;
import com.databricks.sdk.service.serving.ListAppsResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class AppsImpl
implements AppsService {
    private final ApiClient apiClient;

    public AppsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public DeploymentStatus create(DeployAppRequest request) {
        String path = "/api/2.0/preview/apps/deployments";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, DeploymentStatus.class, headers);
    }

    @Override
    public DeleteAppResponse deleteApp(DeleteAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/instances/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.DELETE(path, request, DeleteAppResponse.class, headers);
    }

    @Override
    public GetAppResponse getApp(GetAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/instances/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetAppResponse.class, headers);
    }

    @Override
    public DeploymentStatus getAppDeploymentStatus(GetAppDeploymentStatusRequest request) {
        String path = String.format("/api/2.0/preview/apps/deployments/%s", request.getDeploymentId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, DeploymentStatus.class, headers);
    }

    @Override
    public ListAppsResponse getApps() {
        String path = "/api/2.0/preview/apps/instances";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, ListAppsResponse.class, headers);
    }

    @Override
    public ListAppEventsResponse getEvents(GetEventsRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/events", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListAppEventsResponse.class, headers);
    }
}

