/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.billing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.billing.GetLogDeliveryRequest;
import com.databricks.sdk.service.billing.ListLogDeliveryRequest;
import com.databricks.sdk.service.billing.LogDeliveryService;
import com.databricks.sdk.service.billing.UpdateLogDeliveryConfigurationStatusRequest;
import com.databricks.sdk.service.billing.WrappedCreateLogDeliveryConfiguration;
import com.databricks.sdk.service.billing.WrappedLogDeliveryConfiguration;
import com.databricks.sdk.service.billing.WrappedLogDeliveryConfigurations;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class LogDeliveryImpl
implements LogDeliveryService {
    private final ApiClient apiClient;

    public LogDeliveryImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public WrappedLogDeliveryConfiguration create(WrappedCreateLogDeliveryConfiguration request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, WrappedLogDeliveryConfiguration.class, headers);
    }

    @Override
    public WrappedLogDeliveryConfiguration get(GetLogDeliveryRequest request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery/%s", this.apiClient.configuredAccountID(), request.getLogDeliveryConfigurationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, WrappedLogDeliveryConfiguration.class, headers);
    }

    @Override
    public WrappedLogDeliveryConfigurations list(ListLogDeliveryRequest request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, WrappedLogDeliveryConfigurations.class, headers);
    }

    @Override
    public void patchStatus(UpdateLogDeliveryConfigurationStatusRequest request) {
        String path = String.format("/api/2.0/accounts/%s/log-delivery/%s", this.apiClient.configuredAccountID(), request.getLogDeliveryConfigurationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, Void.class, headers);
    }
}

