/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.DatabricksException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksError
extends DatabricksException {
    private final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final List<String> TRANSIENT_ERROR_STRING_MATCHES = Arrays.asList("com.databricks.backend.manager.util.UnknownWorkerEnvironmentException", "does not have any associated worker environments", "There is no worker environment with id", "Unknown worker environment", "ClusterNotReadyException");
    private static final List<Class<? extends Throwable>> RETRYABLE_CLASSES = Arrays.asList(SocketException.class, SocketTimeoutException.class, ConnectException.class);
    private final String message;
    private final Throwable cause;
    private final String errorCode;
    private final int statusCode;

    public DatabricksError(int statusCode) {
        this("", "OK", statusCode, null);
    }

    public DatabricksError(String errorCode, String message) {
        this(errorCode, message, 400, null);
    }

    public DatabricksError(String errorCode, String message, int statusCode) {
        this(errorCode, message, statusCode, null);
    }

    public DatabricksError(String errorCode, int statusCode, Throwable cause) {
        this(errorCode, cause.getMessage(), statusCode, cause);
    }

    private DatabricksError(String errorCode, String message, int statusCode, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        this.message = message;
        this.cause = cause;
        this.statusCode = statusCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    public boolean isMissing() {
        return this.statusCode == 404;
    }

    public boolean isTooManyRequests() {
        return this.statusCode == 429;
    }

    public boolean isRetriable() {
        if (this.isTooManyRequests()) {
            return true;
        }
        for (String string : TRANSIENT_ERROR_STRING_MATCHES) {
            if (!this.message.contains(string)) continue;
            this.LOG.debug("Attempting retry because of {}", (Object)string);
            return true;
        }
        for (Class clazz : RETRYABLE_CLASSES) {
            if (!DatabricksError.isCausedBy(this.cause, clazz)) continue;
            this.LOG.debug("Attempting retry because cause or nested cause extends {}", (Object)clazz.getName());
            return true;
        }
        return false;
    }

    private static boolean isCausedBy(Throwable throwable, Class<? extends Throwable> clazz) {
        if (throwable == null) {
            return false;
        }
        if (clazz.isInstance(throwable)) {
            return true;
        }
        return DatabricksError.isCausedBy(throwable.getCause(), clazz);
    }
}

