/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsImpl;
import com.databricks.sdk.service.catalog.AccountMetastoreAssignmentsService;
import com.databricks.sdk.service.catalog.AccountsCreateMetastoreAssignment;
import com.databricks.sdk.service.catalog.AccountsMetastoreAssignment;
import com.databricks.sdk.service.catalog.AccountsUpdateMetastoreAssignment;
import com.databricks.sdk.service.catalog.CreateMetastoreAssignmentsResponseItem;
import com.databricks.sdk.service.catalog.DeleteAccountMetastoreAssignmentRequest;
import com.databricks.sdk.service.catalog.GetAccountMetastoreAssignmentRequest;
import com.databricks.sdk.service.catalog.ListAccountMetastoreAssignmentsRequest;
import com.databricks.sdk.service.catalog.MetastoreAssignment;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountMetastoreAssignmentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountMetastoreAssignmentsAPI.class);
    private final AccountMetastoreAssignmentsService impl;

    public AccountMetastoreAssignmentsAPI(ApiClient apiClient) {
        this.impl = new AccountMetastoreAssignmentsImpl(apiClient);
    }

    public AccountMetastoreAssignmentsAPI(AccountMetastoreAssignmentsService mock) {
        this.impl = mock;
    }

    public Iterable<CreateMetastoreAssignmentsResponseItem> create(long workspaceId, String metastoreId) {
        return this.create(new AccountsCreateMetastoreAssignment().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public Iterable<CreateMetastoreAssignmentsResponseItem> create(AccountsCreateMetastoreAssignment request) {
        return this.impl.create(request);
    }

    public void delete(long workspaceId, String metastoreId) {
        this.delete(new DeleteAccountMetastoreAssignmentRequest().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public void delete(DeleteAccountMetastoreAssignmentRequest request) {
        this.impl.delete(request);
    }

    public AccountsMetastoreAssignment get(long workspaceId) {
        return this.get(new GetAccountMetastoreAssignmentRequest().setWorkspaceId(workspaceId));
    }

    public AccountsMetastoreAssignment get(GetAccountMetastoreAssignmentRequest request) {
        return this.impl.get(request);
    }

    public Iterable<MetastoreAssignment> list(String metastoreId) {
        return this.list(new ListAccountMetastoreAssignmentsRequest().setMetastoreId(metastoreId));
    }

    public Iterable<MetastoreAssignment> list(ListAccountMetastoreAssignmentsRequest request) {
        return this.impl.list(request);
    }

    public void update(long workspaceId, String metastoreId) {
        this.update(new AccountsUpdateMetastoreAssignment().setWorkspaceId(workspaceId).setMetastoreId(metastoreId));
    }

    public void update(AccountsUpdateMetastoreAssignment request) {
        this.impl.update(request);
    }

    public AccountMetastoreAssignmentsService impl() {
        return this.impl;
    }
}

