/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateMetastore;
import com.databricks.sdk.service.catalog.CreateMetastoreAssignment;
import com.databricks.sdk.service.catalog.DeleteMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreRequest;
import com.databricks.sdk.service.catalog.GetMetastoreSummaryResponse;
import com.databricks.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.sdk.service.catalog.MetastoreAssignment;
import com.databricks.sdk.service.catalog.MetastoreInfo;
import com.databricks.sdk.service.catalog.MetastoresService;
import com.databricks.sdk.service.catalog.UnassignRequest;
import com.databricks.sdk.service.catalog.UpdateMetastore;
import com.databricks.sdk.service.catalog.UpdateMetastoreAssignment;
import com.databricks.sdk.service.catalog.UpdatePredictiveOptimization;
import com.databricks.sdk.service.catalog.UpdatePredictiveOptimizationResponse;
import com.databricks.sdk.support.Generated;

@Generated
class MetastoresImpl
implements MetastoresService {
    private final ApiClient apiClient;

    public MetastoresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void assign(CreateMetastoreAssignment request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        this.apiClient.PUT(path, request, Void.class);
    }

    @Override
    public MetastoreInfo create(CreateMetastore request) {
        String path = "/api/2.1/unity-catalog/metastores";
        return this.apiClient.POST(path, request, MetastoreInfo.class);
    }

    @Override
    public MetastoreAssignment current() {
        String path = "/api/2.1/unity-catalog/current-metastore-assignment";
        return this.apiClient.GET(path, MetastoreAssignment.class);
    }

    @Override
    public void delete(DeleteMetastoreRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public UpdatePredictiveOptimizationResponse enableOptimization(UpdatePredictiveOptimization request) {
        String path = "/api/2.0/predictive-optimization/service";
        return this.apiClient.PATCH(path, request, UpdatePredictiveOptimizationResponse.class);
    }

    @Override
    public MetastoreInfo get(GetMetastoreRequest request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        return this.apiClient.GET(path, request, MetastoreInfo.class);
    }

    @Override
    public ListMetastoresResponse list() {
        String path = "/api/2.1/unity-catalog/metastores";
        return this.apiClient.GET(path, ListMetastoresResponse.class);
    }

    @Override
    public GetMetastoreSummaryResponse summary() {
        String path = "/api/2.1/unity-catalog/metastore_summary";
        return this.apiClient.GET(path, GetMetastoreSummaryResponse.class);
    }

    @Override
    public void unassign(UnassignRequest request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public MetastoreInfo update(UpdateMetastore request) {
        String path = String.format("/api/2.1/unity-catalog/metastores/%s", request.getId());
        return this.apiClient.PATCH(path, request, MetastoreInfo.class);
    }

    @Override
    public void updateAssignment(UpdateMetastoreAssignment request) {
        String path = String.format("/api/2.1/unity-catalog/workspaces/%s/metastore", request.getWorkspaceId());
        this.apiClient.PATCH(path, request, Void.class);
    }
}

