/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.ml.CreateExperiment;
import com.databricks.sdk.service.ml.CreateExperimentResponse;
import com.databricks.sdk.service.ml.CreateRun;
import com.databricks.sdk.service.ml.CreateRunResponse;
import com.databricks.sdk.service.ml.DeleteExperiment;
import com.databricks.sdk.service.ml.DeleteRun;
import com.databricks.sdk.service.ml.DeleteTag;
import com.databricks.sdk.service.ml.Experiment;
import com.databricks.sdk.service.ml.ExperimentsService;
import com.databricks.sdk.service.ml.GetByNameRequest;
import com.databricks.sdk.service.ml.GetExperimentByNameResponse;
import com.databricks.sdk.service.ml.GetExperimentRequest;
import com.databricks.sdk.service.ml.GetHistoryRequest;
import com.databricks.sdk.service.ml.GetMetricHistoryResponse;
import com.databricks.sdk.service.ml.GetRunRequest;
import com.databricks.sdk.service.ml.GetRunResponse;
import com.databricks.sdk.service.ml.ListArtifactsRequest;
import com.databricks.sdk.service.ml.ListArtifactsResponse;
import com.databricks.sdk.service.ml.ListExperimentsRequest;
import com.databricks.sdk.service.ml.ListExperimentsResponse;
import com.databricks.sdk.service.ml.LogBatch;
import com.databricks.sdk.service.ml.LogInputs;
import com.databricks.sdk.service.ml.LogMetric;
import com.databricks.sdk.service.ml.LogModel;
import com.databricks.sdk.service.ml.LogParam;
import com.databricks.sdk.service.ml.RestoreExperiment;
import com.databricks.sdk.service.ml.RestoreRun;
import com.databricks.sdk.service.ml.SearchExperiments;
import com.databricks.sdk.service.ml.SearchExperimentsResponse;
import com.databricks.sdk.service.ml.SearchRuns;
import com.databricks.sdk.service.ml.SearchRunsResponse;
import com.databricks.sdk.service.ml.SetExperimentTag;
import com.databricks.sdk.service.ml.SetTag;
import com.databricks.sdk.service.ml.UpdateExperiment;
import com.databricks.sdk.service.ml.UpdateRun;
import com.databricks.sdk.service.ml.UpdateRunResponse;
import com.databricks.sdk.support.Generated;

@Generated
class ExperimentsImpl
implements ExperimentsService {
    private final ApiClient apiClient;

    public ExperimentsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateExperimentResponse createExperiment(CreateExperiment request) {
        String path = "/api/2.0/mlflow/experiments/create";
        return this.apiClient.POST(path, request, CreateExperimentResponse.class);
    }

    @Override
    public CreateRunResponse createRun(CreateRun request) {
        String path = "/api/2.0/mlflow/runs/create";
        return this.apiClient.POST(path, request, CreateRunResponse.class);
    }

    @Override
    public void deleteExperiment(DeleteExperiment request) {
        String path = "/api/2.0/mlflow/experiments/delete";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void deleteRun(DeleteRun request) {
        String path = "/api/2.0/mlflow/runs/delete";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void deleteTag(DeleteTag request) {
        String path = "/api/2.0/mlflow/runs/delete-tag";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public GetExperimentByNameResponse getByName(GetByNameRequest request) {
        String path = "/api/2.0/mlflow/experiments/get-by-name";
        return this.apiClient.GET(path, request, GetExperimentByNameResponse.class);
    }

    @Override
    public Experiment getExperiment(GetExperimentRequest request) {
        String path = "/api/2.0/mlflow/experiments/get";
        return this.apiClient.GET(path, request, Experiment.class);
    }

    @Override
    public GetMetricHistoryResponse getHistory(GetHistoryRequest request) {
        String path = "/api/2.0/mlflow/metrics/get-history";
        return this.apiClient.GET(path, request, GetMetricHistoryResponse.class);
    }

    @Override
    public GetRunResponse getRun(GetRunRequest request) {
        String path = "/api/2.0/mlflow/runs/get";
        return this.apiClient.GET(path, request, GetRunResponse.class);
    }

    @Override
    public ListArtifactsResponse listArtifacts(ListArtifactsRequest request) {
        String path = "/api/2.0/mlflow/artifacts/list";
        return this.apiClient.GET(path, request, ListArtifactsResponse.class);
    }

    @Override
    public ListExperimentsResponse listExperiments(ListExperimentsRequest request) {
        String path = "/api/2.0/mlflow/experiments/list";
        return this.apiClient.GET(path, request, ListExperimentsResponse.class);
    }

    @Override
    public void logBatch(LogBatch request) {
        String path = "/api/2.0/mlflow/runs/log-batch";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void logInputs(LogInputs request) {
        String path = "/api/2.0/mlflow/runs/log-inputs";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void logMetric(LogMetric request) {
        String path = "/api/2.0/mlflow/runs/log-metric";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void logModel(LogModel request) {
        String path = "/api/2.0/mlflow/runs/log-model";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void logParam(LogParam request) {
        String path = "/api/2.0/mlflow/runs/log-parameter";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void restoreExperiment(RestoreExperiment request) {
        String path = "/api/2.0/mlflow/experiments/restore";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void restoreRun(RestoreRun request) {
        String path = "/api/2.0/mlflow/runs/restore";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public SearchExperimentsResponse searchExperiments(SearchExperiments request) {
        String path = "/api/2.0/mlflow/experiments/search";
        return this.apiClient.POST(path, request, SearchExperimentsResponse.class);
    }

    @Override
    public SearchRunsResponse searchRuns(SearchRuns request) {
        String path = "/api/2.0/mlflow/runs/search";
        return this.apiClient.POST(path, request, SearchRunsResponse.class);
    }

    @Override
    public void setExperimentTag(SetExperimentTag request) {
        String path = "/api/2.0/mlflow/experiments/set-experiment-tag";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void setTag(SetTag request) {
        String path = "/api/2.0/mlflow/runs/set-tag";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void updateExperiment(UpdateExperiment request) {
        String path = "/api/2.0/mlflow/experiments/update";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public UpdateRunResponse updateRun(UpdateRun request) {
        String path = "/api/2.0/mlflow/runs/update";
        return this.apiClient.POST(path, request, UpdateRunResponse.class);
    }
}

