/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.oauth2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.oauth2.CreatePublishedAppIntegration;
import com.databricks.sdk.service.oauth2.CreatePublishedAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.DeletePublishedAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetPublishedAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.GetPublishedAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetPublishedAppIntegrationsOutput;
import com.databricks.sdk.service.oauth2.PublishedAppIntegrationService;
import com.databricks.sdk.service.oauth2.UpdatePublishedAppIntegration;
import com.databricks.sdk.support.Generated;

@Generated
class PublishedAppIntegrationImpl
implements PublishedAppIntegrationService {
    private final ApiClient apiClient;

    public PublishedAppIntegrationImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreatePublishedAppIntegrationOutput create(CreatePublishedAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations", this.apiClient.configuredAccountID());
        return this.apiClient.POST(path, request, CreatePublishedAppIntegrationOutput.class);
    }

    @Override
    public void delete(DeletePublishedAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public GetPublishedAppIntegrationOutput get(GetPublishedAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        return this.apiClient.GET(path, request, GetPublishedAppIntegrationOutput.class);
    }

    @Override
    public GetPublishedAppIntegrationsOutput list() {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations", this.apiClient.configuredAccountID());
        return this.apiClient.GET(path, GetPublishedAppIntegrationsOutput.class);
    }

    @Override
    public void update(UpdatePublishedAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/published-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        this.apiClient.PATCH(path, request, Void.class);
    }
}

