/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.HeaderFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotebookNativeCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookNativeCredentialsProvider.class);

    @Override
    public String authType() {
        return "runtime";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        if (System.getenv("DATABRICKS_RUNTIME_VERSION") == null) {
            LOG.debug("DBR not detected, skipping runtime auth");
            return null;
        }
        try {
            Object dbutils = NotebookNativeCredentialsProvider.getDbUtils();
            if (dbutils == null) {
                LOG.debug("DBUtils is not available, skipping runtime auth");
                return null;
            }
            Object notebook = NotebookNativeCredentialsProvider.getField(dbutils, "notebook");
            TokenAndUrl testTokenAndUrl = NotebookNativeCredentialsProvider.getTokenAndUrl(notebook);
            if (testTokenAndUrl.url == null) {
                LOG.debug("Workspace URL is not available, skipping runtime auth");
                return null;
            }
            config.setHost(testTokenAndUrl.url);
            return () -> {
                HashMap<String, String> headers = new HashMap<String, String>();
                TokenAndUrl tokenAndUrl = NotebookNativeCredentialsProvider.getTokenAndUrl(notebook);
                headers.put("Authorization", String.format("Bearer %s", tokenAndUrl.token));
                return headers;
            };
        }
        catch (DatabricksException e) {
            LOG.debug("Failed to get token from command context, skipping runtime auth", (Throwable)e);
            return null;
        }
    }

    private static Object getDbUtils() {
        try {
            Class<?> dbutilsHolderClass = Class.forName("com.databricks.dbutils_v1.DBUtilsHolder$");
            Object dbutilsHolder = dbutilsHolderClass.getDeclaredField("MODULE$").get(null);
            InheritableThreadLocal dbutils = (InheritableThreadLocal)NotebookNativeCredentialsProvider.getField(dbutilsHolder, "dbutils0");
            return dbutils.get();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new DatabricksException("failed getting DBUtils", e);
        }
    }

    private static <T> T getField(Object o, String fieldName) {
        Field f;
        try {
            f = o.getClass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new DatabricksException("field " + fieldName + " does not exist", e);
        }
        boolean accessible = f.isAccessible();
        try {
            f.setAccessible(true);
            Object object = f.get(o);
            return (T)object;
        }
        catch (IllegalAccessException e) {
            throw new DatabricksException("failed getting field " + fieldName, e);
        }
        finally {
            if (!accessible) {
                f.setAccessible(false);
            }
        }
    }

    private static TokenAndUrl getTokenAndUrl(Object notebook) {
        try {
            Object testCommandContext = notebook.getClass().getDeclaredMethod("getContext", new Class[0]).invoke(notebook, new Object[0]);
            Object tokenOpt = testCommandContext.getClass().getDeclaredMethod("apiToken", new Class[0]).invoke(testCommandContext, new Object[0]);
            String token = (String)tokenOpt.getClass().getDeclaredMethod("get", new Class[0]).invoke(tokenOpt, new Object[0]);
            Object hostOpt = testCommandContext.getClass().getDeclaredMethod("apiUrl", new Class[0]).invoke(testCommandContext, new Object[0]);
            String host = (String)hostOpt.getClass().getDeclaredMethod("get", new Class[0]).invoke(hostOpt, new Object[0]);
            return new TokenAndUrl(token, host);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | NoSuchElementException e) {
            throw new DatabricksException("failed to get token and URL from command context", e);
        }
    }

    private static class TokenAndUrl {
        public final String token;
        public final String url;

        TokenAndUrl(String token, String url) {
            this.token = token;
            this.url = url;
        }
    }
}

