/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateVolumeRequestContent;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.DeleteVolumeRequest;
import com.databricks.sdk.service.catalog.ListVolumesRequest;
import com.databricks.sdk.service.catalog.ListVolumesResponseContent;
import com.databricks.sdk.service.catalog.ReadVolumeRequest;
import com.databricks.sdk.service.catalog.UpdateVolumeRequestContent;
import com.databricks.sdk.service.catalog.VolumeInfo;
import com.databricks.sdk.service.catalog.VolumesService;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class VolumesImpl
implements VolumesService {
    private final ApiClient apiClient;

    public VolumesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public VolumeInfo create(CreateVolumeRequestContent request) {
        String path = "/api/2.1/unity-catalog/volumes";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, VolumeInfo.class, headers);
    }

    @Override
    public void delete(DeleteVolumeRequest request) {
        String path = String.format("/api/2.1/unity-catalog/volumes/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public ListVolumesResponseContent list(ListVolumesRequest request) {
        String path = "/api/2.1/unity-catalog/volumes";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListVolumesResponseContent.class, headers);
    }

    @Override
    public VolumeInfo read(ReadVolumeRequest request) {
        String path = String.format("/api/2.1/unity-catalog/volumes/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, VolumeInfo.class, headers);
    }

    @Override
    public VolumeInfo update(UpdateVolumeRequestContent request) {
        String path = String.format("/api/2.1/unity-catalog/volumes/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, VolumeInfo.class, headers);
    }
}

