/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.serving;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.serving.App;
import com.databricks.sdk.service.serving.AppDeployment;
import com.databricks.sdk.service.serving.AppEnvironment;
import com.databricks.sdk.service.serving.AppsService;
import com.databricks.sdk.service.serving.CreateAppDeploymentRequest;
import com.databricks.sdk.service.serving.CreateAppRequest;
import com.databricks.sdk.service.serving.DeleteAppRequest;
import com.databricks.sdk.service.serving.DeleteResponse;
import com.databricks.sdk.service.serving.GetAppDeploymentRequest;
import com.databricks.sdk.service.serving.GetAppEnvironmentRequest;
import com.databricks.sdk.service.serving.GetAppRequest;
import com.databricks.sdk.service.serving.ListAppDeploymentsRequest;
import com.databricks.sdk.service.serving.ListAppDeploymentsResponse;
import com.databricks.sdk.service.serving.ListAppsRequest;
import com.databricks.sdk.service.serving.ListAppsResponse;
import com.databricks.sdk.service.serving.StopAppRequest;
import com.databricks.sdk.service.serving.StopAppResponse;
import com.databricks.sdk.service.serving.UpdateAppRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class AppsImpl
implements AppsService {
    private final ApiClient apiClient;

    public AppsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public App create(CreateAppRequest request) {
        String path = "/api/2.0/preview/apps";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, App.class, headers);
    }

    @Override
    public AppDeployment createDeployment(CreateAppDeploymentRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/deployments", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, AppDeployment.class, headers);
    }

    @Override
    public void delete(DeleteAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public App get(GetAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, App.class, headers);
    }

    @Override
    public AppDeployment getDeployment(GetAppDeploymentRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/deployments/%s", request.getAppName(), request.getDeploymentId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, AppDeployment.class, headers);
    }

    @Override
    public AppEnvironment getEnvironment(GetAppEnvironmentRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/environment", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, AppEnvironment.class, headers);
    }

    @Override
    public ListAppsResponse list(ListAppsRequest request) {
        String path = "/api/2.0/preview/apps";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListAppsResponse.class, headers);
    }

    @Override
    public ListAppDeploymentsResponse listDeployments(ListAppDeploymentsRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/deployments", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListAppDeploymentsResponse.class, headers);
    }

    @Override
    public void stop(StopAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/stop", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, StopAppResponse.class, headers);
    }

    @Override
    public App update(UpdateAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, App.class, headers);
    }
}

