/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sharing.CentralCleanRoomInfo;
import com.databricks.sdk.service.sharing.CleanRoomInfo;
import com.databricks.sdk.service.sharing.CleanRoomsImpl;
import com.databricks.sdk.service.sharing.CleanRoomsService;
import com.databricks.sdk.service.sharing.CreateCleanRoom;
import com.databricks.sdk.service.sharing.DeleteCleanRoomRequest;
import com.databricks.sdk.service.sharing.GetCleanRoomRequest;
import com.databricks.sdk.service.sharing.ListCleanRoomsRequest;
import com.databricks.sdk.service.sharing.ListCleanRoomsResponse;
import com.databricks.sdk.service.sharing.UpdateCleanRoom;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CleanRoomsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CleanRoomsAPI.class);
    private final CleanRoomsService impl;

    public CleanRoomsAPI(ApiClient apiClient) {
        this.impl = new CleanRoomsImpl(apiClient);
    }

    public CleanRoomsAPI(CleanRoomsService mock) {
        this.impl = mock;
    }

    public CleanRoomInfo create(String name, CentralCleanRoomInfo remoteDetailedInfo) {
        return this.create(new CreateCleanRoom().setName(name).setRemoteDetailedInfo(remoteDetailedInfo));
    }

    public CleanRoomInfo create(CreateCleanRoom request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteCleanRoomRequest().setName(name));
    }

    public void delete(DeleteCleanRoomRequest request) {
        this.impl.delete(request);
    }

    public CleanRoomInfo get(String name) {
        return this.get(new GetCleanRoomRequest().setName(name));
    }

    public CleanRoomInfo get(GetCleanRoomRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CleanRoomInfo> list(ListCleanRoomsRequest request) {
        return new Paginator(request, this.impl::list, ListCleanRoomsResponse::getCleanRooms, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CleanRoomInfo update(String name) {
        return this.update(new UpdateCleanRoom().setName(name));
    }

    public CleanRoomInfo update(UpdateCleanRoom request) {
        return this.impl.update(request);
    }

    public CleanRoomsService impl() {
        return this.impl;
    }
}

