/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.utils;

import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.ProxyConfig;
import java.security.Principal;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;

public class ProxyUtils {
    public static void setupProxy(ProxyConfig config, HttpClientBuilder builder) {
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUser = null;
        String proxyPassword = null;
        ProxyConfig.ProxyAuthType proxyAuthType = null;
        if (config.getUseSystemProperties() != null && config.getUseSystemProperties().booleanValue()) {
            builder.useSystemProperties();
            String protocol = System.getProperty("https.proxyHost") != null ? "https" : "http";
            proxyHost = System.getProperty(protocol + ".proxyHost");
            proxyPort = Integer.parseInt(System.getProperty(protocol + ".proxyPort"));
            proxyUser = System.getProperty(protocol + ".proxyUser");
            proxyPassword = System.getProperty(protocol + ".proxyPassword");
            proxyAuthType = ProxyConfig.ProxyAuthType.BASIC;
        }
        if (config.getHost() != null) {
            proxyHost = config.getHost();
            proxyPort = config.getPort();
            proxyUser = config.getUsername();
            proxyPassword = config.getPassword();
            proxyAuthType = config.getProxyAuthType();
            builder.setProxy(new HttpHost(proxyHost, proxyPort.intValue()));
        }
        ProxyUtils.setupProxyAuth(proxyHost, proxyPort, proxyAuthType, proxyUser, proxyPassword, builder);
    }

    public static void setupProxyAuth(String proxyHost, Integer proxyPort, ProxyConfig.ProxyAuthType proxyAuthType, String proxyUser, String proxyPassword, HttpClientBuilder builder) {
        if (proxyAuthType == null) {
            return;
        }
        AuthScope authScope = new AuthScope(proxyHost, proxyPort.intValue());
        switch (proxyAuthType) {
            case NONE: {
                break;
            }
            case BASIC: {
                ProxyUtils.setupBasicProxyAuth(builder, authScope, proxyUser, proxyPassword);
                break;
            }
            case SPNEGO: {
                ProxyUtils.setupNegotiateProxyAuth(builder, authScope);
                break;
            }
            default: {
                throw new DatabricksException("Unknown proxy auth type: " + (Object)((Object)proxyAuthType));
            }
        }
    }

    public static void setupNegotiateProxyAuth(HttpClientBuilder builder, AuthScope authScope) {
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        Credentials useJaasCreds = new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(authScope, useJaasCreds);
        builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build());
    }

    public static void setupBasicProxyAuth(HttpClientBuilder builder, AuthScope authScope, String proxyUser, String proxyPassword) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
    }
}

