/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.marketplace.CreateListingRequest;
import com.databricks.sdk.service.marketplace.CreateListingResponse;
import com.databricks.sdk.service.marketplace.DeleteListingRequest;
import com.databricks.sdk.service.marketplace.GetListingRequest;
import com.databricks.sdk.service.marketplace.GetListingResponse;
import com.databricks.sdk.service.marketplace.GetListingsRequest;
import com.databricks.sdk.service.marketplace.GetListingsResponse;
import com.databricks.sdk.service.marketplace.Listing;
import com.databricks.sdk.service.marketplace.ProviderListingsImpl;
import com.databricks.sdk.service.marketplace.ProviderListingsService;
import com.databricks.sdk.service.marketplace.UpdateListingRequest;
import com.databricks.sdk.service.marketplace.UpdateListingResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProviderListingsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderListingsAPI.class);
    private final ProviderListingsService impl;

    public ProviderListingsAPI(ApiClient apiClient) {
        this.impl = new ProviderListingsImpl(apiClient);
    }

    public ProviderListingsAPI(ProviderListingsService mock) {
        this.impl = mock;
    }

    public CreateListingResponse create(Listing listing) {
        return this.create(new CreateListingRequest().setListing(listing));
    }

    public CreateListingResponse create(CreateListingRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteListingRequest().setId(id));
    }

    public void delete(DeleteListingRequest request) {
        this.impl.delete(request);
    }

    public GetListingResponse get(String id) {
        return this.get(new GetListingRequest().setId(id));
    }

    public GetListingResponse get(GetListingRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Listing> list(GetListingsRequest request) {
        return new Paginator(request, this.impl::list, GetListingsResponse::getListings, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateListingResponse update(String id, Listing listing) {
        return this.update(new UpdateListingRequest().setId(id).setListing(listing));
    }

    public UpdateListingResponse update(UpdateListingRequest request) {
        return this.impl.update(request);
    }

    public ProviderListingsService impl() {
        return this.impl;
    }
}

