/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sql.Dashboard;
import com.databricks.sdk.service.sql.DashboardEditContent;
import com.databricks.sdk.service.sql.DashboardPostContent;
import com.databricks.sdk.service.sql.DashboardsService;
import com.databricks.sdk.service.sql.DeleteDashboardRequest;
import com.databricks.sdk.service.sql.DeleteResponse;
import com.databricks.sdk.service.sql.GetDashboardRequest;
import com.databricks.sdk.service.sql.ListDashboardsRequest;
import com.databricks.sdk.service.sql.ListResponse;
import com.databricks.sdk.service.sql.RestoreDashboardRequest;
import com.databricks.sdk.service.sql.RestoreResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class DashboardsImpl
implements DashboardsService {
    private final ApiClient apiClient;

    public DashboardsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Dashboard create(DashboardPostContent request) {
        String path = "/api/2.0/preview/sql/dashboards";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Dashboard.class, headers);
    }

    @Override
    public void delete(DeleteDashboardRequest request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public Dashboard get(GetDashboardRequest request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Dashboard.class, headers);
    }

    @Override
    public ListResponse list(ListDashboardsRequest request) {
        String path = "/api/2.0/preview/sql/dashboards";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListResponse.class, headers);
    }

    @Override
    public void restore(RestoreDashboardRequest request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/trash/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.POST(path, null, RestoreResponse.class, headers);
    }

    @Override
    public Dashboard update(DashboardEditContent request) {
        String path = String.format("/api/2.0/preview/sql/dashboards/%s", request.getDashboardId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Dashboard.class, headers);
    }
}

