/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UserAgent {
    private static String product = "unknown";
    private static String productVersion = "0.0.0";
    private static final ArrayList<Info> otherInfo = new ArrayList();
    private static final String version = "0.34.0";
    private static final String semVerCore = "(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)";
    private static final String semVerPrerelease = "(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?";
    private static final String semVerBuildmetadata = "(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?";
    private static final Pattern regexpSemVer = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern regexpAlphanum = Pattern.compile("^[0-9A-Za-z_\\.\\+-]+$");
    private static final Pattern regexpAlphanumInverse = Pattern.compile("[^0-9A-Za-z_\\.\\+-]");

    public static void withProduct(String product, String productVersion) {
        UserAgent.product = product;
        UserAgent.productVersion = productVersion;
    }

    public static String sanitize(String s) {
        return regexpAlphanumInverse.matcher(s).replaceAll("-");
    }

    public static boolean matchSemVer(String s) throws IllegalArgumentException {
        if (regexpSemVer.matcher(s).matches()) {
            return true;
        }
        throw new IllegalArgumentException("Invalid semver string: " + s);
    }

    public static boolean matchAlphanum(String s) throws IllegalArgumentException {
        if (regexpAlphanum.matcher(s).matches()) {
            return true;
        }
        throw new IllegalArgumentException("Invalid alphanumeric string: " + s);
    }

    public static boolean matchAlphanumOrSemVer(String s) throws IllegalArgumentException {
        if (regexpAlphanum.matcher(s).matches() || regexpSemVer.matcher(s).matches()) {
            return true;
        }
        throw new IllegalArgumentException("Invalid alphanumeric or semver string: " + s);
    }

    public static void withPartner(String partner) {
        UserAgent.withOtherInfo("partner", partner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withOtherInfo(String key, String value) {
        UserAgent.matchAlphanum(key);
        UserAgent.matchAlphanumOrSemVer(value);
        ArrayList<Info> arrayList = otherInfo;
        synchronized (arrayList) {
            otherInfo.add(new Info(key, value));
        }
    }

    private static String osName() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("mac")) {
            return "darwin";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("win")) {
            return "windows";
        }
        return "unknown";
    }

    private static String jvmVersion() {
        String jvmVersion = System.getProperty("java.version");
        String[] split = jvmVersion.split("_");
        return split[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asString() {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add(String.format("%s/%s", product, productVersion));
        segments.add(String.format("databricks-sdk-java/%s", version));
        segments.add(String.format("jvm/%s", UserAgent.jvmVersion()));
        segments.add(String.format("os/%s", UserAgent.osName()));
        ArrayList<Info> arrayList = otherInfo;
        synchronized (arrayList) {
            segments.addAll(otherInfo.stream().map(e -> String.format("%s/%s", e.getKey(), e.getValue())).collect(Collectors.toSet()));
        }
        return segments.stream().collect(Collectors.joining(" "));
    }

    private static class Info {
        private String key;
        private String value;

        public Info(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

